"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const core_1 = require("@nestjs/core");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const database_module_1 = require("./database/database.module");
const auth_module_1 = require("./auth/auth.module");
const category_module_1 = require("./category/category.module");
const private_route_guard_1 = require("./common/guards/private-route.guard");
const customer_module_1 = require("./customer/customer.module");
const dashboard_module_1 = require("./dashboard/dashboard.module");
const order_module_1 = require("./order/order.module");
const product_module_1 = require("./product/product.module");
const purchase_order_module_1 = require("./purchase-order/purchase-order.module");
const stock_module_1 = require("./stock/stock.module");
const supplier_product_module_1 = require("./supplier-product/supplier-product.module");
const supplier_module_1 = require("./supplier/supplier.module");
const size_module_1 = require("./size/size.module");
const color_module_1 = require("./color/color.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({
                isGlobal: true,
            }),
            database_module_1.DatabaseModule,
            supplier_module_1.SupplierModule,
            product_module_1.ProductModule,
            supplier_product_module_1.SupplierProductModule,
            purchase_order_module_1.PurchaseOrderModule,
            auth_module_1.AuthModule,
            customer_module_1.CustomerModule,
            dashboard_module_1.DashboardModule,
            stock_module_1.StockModule,
            order_module_1.OrderModule,
            category_module_1.CategoryModule,
            size_module_1.SizeModule,
            color_module_1.ColorModule,
        ],
        controllers: [app_controller_1.AppController],
        providers: [
            app_service_1.AppService,
            {
                provide: core_1.APP_GUARD,
                useClass: private_route_guard_1.PrivateRouteGuard,
            },
        ],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map