import { Request } from "express";
import { AuthService, type AuthResponse } from "./auth.service";
type AuthenticatedRequest = Request & {
    user: AuthResponse["user"];
};
import { LoginDto } from "./dto/login.dto";
import { RegisterUserDto } from "./dto/register-user.dto";
export declare class AuthController {
    private readonly authService;
    constructor(authService: AuthService);
    register(dto: RegisterUserDto): Promise<AuthResponse>;
    login(dto: LoginDto): Promise<AuthResponse>;
    profile(request: AuthenticatedRequest): AuthResponse["user"];
}
export {};
