"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const category_entity_1 = require("../entities/category.entity");
let CategoryService = class CategoryService {
    categoryRepository;
    constructor(categoryRepository) {
        this.categoryRepository = categoryRepository;
    }
    async create(createCategoryDto) {
        const { parentId, status, ...categoryData } = createCategoryDto;
        let parent = null;
        if (parentId !== undefined && parentId !== null) {
            parent = await this.findExistingParent(parentId);
        }
        const category = this.categoryRepository.create({
            ...categoryData,
            status: status ?? 1,
            parent,
        });
        return this.categoryRepository.save(category);
    }
    async findAll(paginationDto) {
        const page = Math.max(Number.parseInt(paginationDto.page ?? "1", 10) || 1, 1);
        const limit = Math.max(Number.parseInt(paginationDto.limit ?? "10", 10) || 10, 1);
        const search = paginationDto.search?.trim() ?? "";
        const queryBuilder = this.categoryRepository.createQueryBuilder("category");
        if (search) {
            queryBuilder.where("(LOWER(category.category_name) LIKE LOWER(:search) OR LOWER(category.title) LIKE LOWER(:search) OR LOWER(category.subtitle) LIKE LOWER(:search))", { search: `%${search}%` });
        }
        queryBuilder.orderBy("category.category_name", "ASC");
        const total = await queryBuilder.clone().getCount();
        const rawIds = await queryBuilder
            .clone()
            .select("category.id", "id")
            .skip((page - 1) * limit)
            .take(limit)
            .getRawMany();
        const ids = rawIds.map((row) => Number(row.id)).filter(Boolean);
        let data = [];
        if (ids.length > 0) {
            const categories = await this.categoryRepository.find({
                where: { id: (0, typeorm_2.In)(ids) },
                relations: ["parent", "children", "products"],
                order: { category_name: "ASC" },
            });
            const categoriesById = new Map(categories.map((category) => [category.id, category]));
            data = ids
                .map((id) => categoriesById.get(id))
                .filter((category) => Boolean(category));
        }
        const totalPages = total > 0 ? Math.ceil(total / limit) : 0;
        return {
            data,
            page,
            limit,
            total,
            previous: page > 1 ? page - 1 : null,
            next: page < totalPages ? page + 1 : null,
        };
    }
    async findOne(id) {
        const category = await this.categoryRepository.findOne({
            where: { id },
            relations: ["parent", "children", "products"],
        });
        if (!category) {
            throw new common_1.NotFoundException(`Category with ID ${id} not found`);
        }
        return category;
    }
    async update(id, updateCategoryDto) {
        const category = await this.findOne(id);
        const { parentId, status, ...categoryData } = updateCategoryDto;
        if (parentId !== undefined) {
            if (parentId === null) {
                category.parent = null;
            }
            else {
                if (parentId === id) {
                    throw new common_1.BadRequestException("A category cannot be its own parent");
                }
                category.parent = await this.findExistingParent(parentId);
            }
        }
        if (status !== undefined) {
            category.status = status;
        }
        this.categoryRepository.merge(category, categoryData);
        return this.categoryRepository.save(category);
    }
    async remove(id) {
        const category = await this.findOne(id);
        await this.categoryRepository.remove(category);
    }
    async findExistingParent(parentId) {
        const parent = await this.categoryRepository.findOne({
            where: { id: parentId },
        });
        if (!parent) {
            throw new common_1.NotFoundException(`Parent category with ID ${parentId} not found`);
        }
        return parent;
    }
};
exports.CategoryService = CategoryService;
exports.CategoryService = CategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(category_entity_1.Category)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], CategoryService);
//# sourceMappingURL=category.service.js.map