"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColorController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const pagination_dto_1 = require("../common/dto/pagination.dto");
const color_service_1 = require("./color.service");
const create_color_dto_1 = require("./dto/create-color.dto");
const update_color_dto_1 = require("./dto/update-color.dto");
let ColorController = class ColorController {
    colorService;
    constructor(colorService) {
        this.colorService = colorService;
    }
    create(createColorDto) {
        return this.colorService.create(createColorDto);
    }
    findAll(paginationDto) {
        return this.colorService.findAll(paginationDto);
    }
    findOne(id) {
        return this.colorService.findOne(+id);
    }
    update(id, updateColorDto) {
        return this.colorService.update(+id, updateColorDto);
    }
    async remove(id) {
        await this.colorService.remove(+id);
    }
};
exports.ColorController = ColorController;
__decorate([
    (0, common_1.Post)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.CREATED),
    (0, swagger_1.ApiOperation)({ summary: "Create a new color" }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: "The color has been created.",
    }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Validation failed." }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_color_dto_1.CreateColorDto]),
    __metadata("design:returntype", void 0)
], ColorController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: "Retrieve colors with pagination and search" }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Paginated list of colors.",
    }),
    (0, swagger_1.ApiQuery)({
        name: "limit",
        type: Number,
        required: false,
        description: "Number of items per page",
    }),
    (0, swagger_1.ApiQuery)({
        name: "page",
        type: Number,
        required: false,
        description: "Page number",
    }),
    (0, swagger_1.ApiQuery)({
        name: "query",
        type: String,
        required: false,
        description: "Search keyword (alias: search)",
    }),
    (0, swagger_1.ApiQuery)({
        name: "search",
        type: String,
        required: false,
        description: "Deprecated search keyword; prefer query",
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_dto_1.PaginationDto]),
    __metadata("design:returntype", void 0)
], ColorController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Retrieve a color by ID" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Color identifier" }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Returns the color with the specified ID.",
    }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Color not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ColorController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Update an existing color" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Color identifier" }),
    (0, swagger_1.ApiBody)({ type: update_color_dto_1.UpdateColorDto }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "The color has been updated.",
    }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Color not found." }),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_color_dto_1.UpdateColorDto]),
    __metadata("design:returntype", void 0)
], ColorController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(":id"),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, swagger_1.ApiOperation)({ summary: "Delete a color" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Color identifier" }),
    (0, swagger_1.ApiResponse)({ status: 204, description: "Color removed." }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Color not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ColorController.prototype, "remove", null);
exports.ColorController = ColorController = __decorate([
    (0, swagger_1.ApiTags)("Colors"),
    (0, common_1.Controller)("colors"),
    __metadata("design:paramtypes", [color_service_1.ColorService])
], ColorController);
//# sourceMappingURL=color.controller.js.map