import { Repository } from "typeorm";
import { Color } from "../entities/color.entity";
import { PaginationDto } from "../common/dto/pagination.dto";
import { CreateColorDto } from "./dto/create-color.dto";
import { UpdateColorDto } from "./dto/update-color.dto";
export declare class ColorService {
    private readonly colorRepository;
    constructor(colorRepository: Repository<Color>);
    create(createColorDto: CreateColorDto): Promise<Color>;
    findAll(paginationDto: PaginationDto): Promise<{
        data: Color[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    findOne(id: number): Promise<Color>;
    update(id: number, updateColorDto: UpdateColorDto): Promise<Color>;
    remove(id: number): Promise<void>;
    resolveColors(colorIds: number[]): Promise<Map<number, Color>>;
}
