"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColorService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const color_entity_1 = require("../entities/color.entity");
let ColorService = class ColorService {
    colorRepository;
    constructor(colorRepository) {
        this.colorRepository = colorRepository;
    }
    async create(createColorDto) {
        const color = this.colorRepository.create(createColorDto);
        return this.colorRepository.save(color);
    }
    async findAll(paginationDto) {
        const page = Math.max(Number.parseInt(paginationDto.page ?? "1", 10) || 1, 1);
        const limit = Math.max(Number.parseInt(paginationDto.limit ?? "10", 10) || 10, 1);
        const search = paginationDto.search?.trim().toLowerCase() ?? "";
        const queryBuilder = this.colorRepository
            .createQueryBuilder("color")
            .orderBy("color.created_at", "DESC");
        if (search) {
            queryBuilder.where("LOWER(color.name) LIKE :search", {
                search: `%${search}%`,
            });
        }
        const [data, total] = await queryBuilder
            .skip((page - 1) * limit)
            .take(limit)
            .getManyAndCount();
        const totalPages = total > 0 ? Math.ceil(total / limit) : 0;
        return {
            data,
            page,
            limit,
            total,
            previous: page > 1 ? page - 1 : null,
            next: page < totalPages ? page + 1 : null,
        };
    }
    async findOne(id) {
        const color = await this.colorRepository.findOne({ where: { id } });
        if (!color) {
            throw new common_1.NotFoundException(`Color with ID ${id} not found`);
        }
        return color;
    }
    async update(id, updateColorDto) {
        const color = await this.findOne(id);
        this.colorRepository.merge(color, updateColorDto);
        return this.colorRepository.save(color);
    }
    async remove(id) {
        const result = await this.colorRepository.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Color with ID ${id} not found`);
        }
    }
    async resolveColors(colorIds) {
        const uniqueIds = Array.from(new Set(colorIds));
        if (uniqueIds.length === 0) {
            throw new common_1.BadRequestException("At least one color must be provided");
        }
        const colors = await this.colorRepository.find({
            where: { id: (0, typeorm_2.In)(uniqueIds) },
        });
        if (colors.length !== uniqueIds.length) {
            const foundIds = new Set(colors.map((color) => color.id));
            const missing = uniqueIds.filter((id) => !foundIds.has(id));
            throw new common_1.NotFoundException(`Colors not found for identifiers: ${missing.join(", ")}`);
        }
        return new Map(colors.map((color) => [color.id, color]));
    }
};
exports.ColorService = ColorService;
exports.ColorService = ColorService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(color_entity_1.Color)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ColorService);
//# sourceMappingURL=color.service.js.map