"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateRouteGuard = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const passport_1 = require("@nestjs/passport");
const private_decorator_1 = require("../decorators/private.decorator");
let PrivateRouteGuard = class PrivateRouteGuard extends (0, passport_1.AuthGuard)("jwt") {
    reflector;
    constructor(reflector) {
        super();
        this.reflector = reflector;
    }
    async canActivate(context) {
        const isPrivate = this.reflector.getAllAndOverride(private_decorator_1.IS_PRIVATE_KEY, [
            context.getHandler(),
            context.getClass(),
        ]);
        if (!isPrivate) {
            return true;
        }
        return (await super.canActivate(context));
    }
    handleRequest(err, user, _info, _context, _status) {
        if (err || !user) {
            throw err || new common_1.UnauthorizedException("Authentication required");
        }
        return user;
    }
};
exports.PrivateRouteGuard = PrivateRouteGuard;
exports.PrivateRouteGuard = PrivateRouteGuard = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.Reflector])
], PrivateRouteGuard);
//# sourceMappingURL=private-route.guard.js.map