import { CustomerService } from "./customer.service";
import { CreateCustomerDto } from "./dto/create-customer.dto";
import { UpdateCustomerDto } from "./dto/update-customer.dto";
import { PaginationDto } from "../common/dto/pagination.dto";
export declare class CustomerController {
    private readonly customerService;
    constructor(customerService: CustomerService);
    create(createCustomerDto: CreateCustomerDto): Promise<import("../entities/customer.entity").Customer>;
    findAll(paginationDto: PaginationDto): Promise<{
        data: import("../entities/customer.entity").Customer[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    findOne(id: string): Promise<import("../entities/customer.entity").Customer>;
    update(id: string, updateCustomerDto: UpdateCustomerDto): Promise<import("../entities/customer.entity").Customer>;
    remove(id: string): Promise<void>;
}
