"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const customer_service_1 = require("./customer.service");
const create_customer_dto_1 = require("./dto/create-customer.dto");
const update_customer_dto_1 = require("./dto/update-customer.dto");
const pagination_dto_1 = require("../common/dto/pagination.dto");
let CustomerController = class CustomerController {
    customerService;
    constructor(customerService) {
        this.customerService = customerService;
    }
    create(createCustomerDto) {
        return this.customerService.create(createCustomerDto);
    }
    findAll(paginationDto) {
        return this.customerService.findAll(paginationDto);
    }
    findOne(id) {
        return this.customerService.findOne(+id);
    }
    update(id, updateCustomerDto) {
        return this.customerService.update(+id, updateCustomerDto);
    }
    remove(id) {
        return this.customerService.remove(+id);
    }
};
exports.CustomerController = CustomerController;
__decorate([
    (0, common_1.Post)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.CREATED),
    (0, swagger_1.ApiOperation)({ summary: "Create a new customer" }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: "The customer has been successfully created.",
    }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Validation failed." }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_customer_dto_1.CreateCustomerDto]),
    __metadata("design:returntype", void 0)
], CustomerController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({
        summary: "Retrieve customers with pagination and optional search",
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Returns customers with pagination metadata.",
    }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Validation failed." }),
    (0, swagger_1.ApiQuery)({
        name: "limit",
        type: Number,
        required: false,
        description: "Limit of items per page",
    }),
    (0, swagger_1.ApiQuery)({
        name: "page",
        type: Number,
        required: false,
        description: "Page of items",
    }),
    (0, swagger_1.ApiQuery)({
        name: "query",
        type: String,
        required: false,
        description: "Search keyword (alias: search)",
    }),
    (0, swagger_1.ApiQuery)({
        name: "search",
        type: String,
        required: false,
        description: "Deprecated search keyword; prefer query",
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_dto_1.PaginationDto]),
    __metadata("design:returntype", void 0)
], CustomerController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Retrieve a customer by ID" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Customer identifier" }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Returns the customer with the specified ID.",
    }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Customer not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CustomerController.prototype, "findOne", null);
__decorate([
    (0, common_1.Put)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Update an existing customer" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Customer identifier" }),
    (0, swagger_1.ApiBody)({ type: update_customer_dto_1.UpdateCustomerDto }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "The customer has been successfully updated.",
    }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Customer not found." }),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_customer_dto_1.UpdateCustomerDto]),
    __metadata("design:returntype", void 0)
], CustomerController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(":id"),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, swagger_1.ApiOperation)({ summary: "Delete a customer" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Customer identifier" }),
    (0, swagger_1.ApiResponse)({ status: 204, description: "Customer removed." }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Customer not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CustomerController.prototype, "remove", null);
exports.CustomerController = CustomerController = __decorate([
    (0, swagger_1.ApiTags)("Customers"),
    (0, common_1.Controller)("customers"),
    __metadata("design:paramtypes", [customer_service_1.CustomerService])
], CustomerController);
//# sourceMappingURL=customer.controller.js.map