"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const customer_entity_1 = require("../entities/customer.entity");
let CustomerService = class CustomerService {
    customerRepository;
    constructor(customerRepository) {
        this.customerRepository = customerRepository;
    }
    create(createCustomerDto) {
        const customer = this.customerRepository.create({
            first_name: createCustomerDto.firstName,
            last_name: createCustomerDto.lastName,
            email: createCustomerDto.email,
            phone: createCustomerDto.phone ?? null,
            address: createCustomerDto.address ?? null,
        });
        return this.customerRepository.save(customer);
    }
    async findAll(paginationDto) {
        const page = Math.max(Number.parseInt(paginationDto.page ?? "1", 10) || 1, 1);
        const limit = Math.max(Number.parseInt(paginationDto.limit ?? "10", 10) || 10, 1);
        const search = paginationDto.searchTerm;
        const queryBuilder = this.customerRepository
            .createQueryBuilder("customer")
            .orderBy("customer.created_at", "DESC");
        if (search) {
            queryBuilder.where("(LOWER(customer.first_name) LIKE LOWER(:search) OR LOWER(customer.last_name) LIKE LOWER(:search) OR LOWER(customer.email) LIKE LOWER(:search) OR LOWER(customer.phone) LIKE LOWER(:search))", { search: `%${search}%` });
        }
        const [data, total] = await queryBuilder
            .skip((page - 1) * limit)
            .take(limit)
            .getManyAndCount();
        const totalPages = total > 0 ? Math.ceil(total / limit) : 0;
        return {
            data,
            page,
            limit,
            total,
            previous: page > 1 ? page - 1 : null,
            next: page < totalPages ? page + 1 : null,
        };
    }
    async findOne(id) {
        const customer = await this.customerRepository.findOne({ where: { id } });
        if (!customer) {
            throw new common_1.NotFoundException(`Customer with ID ${id} not found`);
        }
        return customer;
    }
    async update(id, updateCustomerDto) {
        const customer = await this.findOne(id);
        customer.first_name =
            updateCustomerDto.firstName ?? customer.first_name;
        customer.last_name = updateCustomerDto.lastName ?? customer.last_name;
        customer.email = updateCustomerDto.email ?? customer.email;
        customer.phone =
            updateCustomerDto.phone !== undefined
                ? updateCustomerDto.phone
                : customer.phone;
        customer.address =
            updateCustomerDto.address !== undefined
                ? updateCustomerDto.address
                : customer.address;
        return this.customerRepository.save(customer);
    }
    async remove(id) {
        const result = await this.customerRepository.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Customer with ID ${id} not found`);
        }
    }
};
exports.CustomerService = CustomerService;
exports.CustomerService = CustomerService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(customer_entity_1.Customer)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], CustomerService);
//# sourceMappingURL=customer.service.js.map