import { Repository } from "typeorm";
import { SupplierProduct } from "../entities/supplier-product.entity";
import { Order } from "../entities/order.entity";
import { Customer } from "../entities/customer.entity";
import { OrderReturn } from "../entities/order-return.entity";
import { DashboardOverviewDto } from "./dto/dashboard-overview.dto";
import { DashboardOverviewQueryDto } from "./dto/dashboard-overview-query.dto";
export declare class DashboardService {
    private readonly supplierProductRepository;
    private readonly orderRepository;
    private readonly customerRepository;
    private readonly orderReturnRepository;
    constructor(supplierProductRepository: Repository<SupplierProduct>, orderRepository: Repository<Order>, customerRepository: Repository<Customer>, orderReturnRepository: Repository<OrderReturn>);
    getOverview(filters?: DashboardOverviewQueryDto): Promise<DashboardOverviewDto>;
    private parseDateRange;
    private buildDateWhere;
    private createDateCondition;
}
