"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const supplier_product_entity_1 = require("../entities/supplier-product.entity");
const order_entity_1 = require("../entities/order.entity");
const customer_entity_1 = require("../entities/customer.entity");
const order_return_entity_1 = require("../entities/order-return.entity");
let DashboardService = class DashboardService {
    supplierProductRepository;
    orderRepository;
    customerRepository;
    orderReturnRepository;
    constructor(supplierProductRepository, orderRepository, customerRepository, orderReturnRepository) {
        this.supplierProductRepository = supplierProductRepository;
        this.orderRepository = orderRepository;
        this.customerRepository = customerRepository;
        this.orderReturnRepository = orderReturnRepository;
    }
    async getOverview(filters) {
        const dateRange = this.parseDateRange(filters);
        const supplierProductWhere = this.buildDateWhere("created_at", dateRange);
        const orderWhere = this.buildDateWhere("created_at", dateRange);
        const customerWhere = this.buildDateWhere("created_at", dateRange);
        const orderReturnWhere = this.buildDateWhere("created_at", dateRange);
        const [totalSupplierProducts, totalOrders, totalCustomers, totalReturns,] = await Promise.all([
            this.supplierProductRepository.count(supplierProductWhere ? { where: supplierProductWhere } : undefined),
            this.orderRepository.count(orderWhere ? { where: orderWhere } : undefined),
            this.customerRepository.count(customerWhere ? { where: customerWhere } : undefined),
            this.orderReturnRepository.count(orderReturnWhere ? { where: orderReturnWhere } : undefined),
        ]);
        return {
            totalSupplierProducts,
            totalOrders,
            totalCustomers,
            totalReturns,
        };
    }
    parseDateRange(filters) {
        if (!filters?.startDate && !filters?.endDate) {
            return {};
        }
        const start = filters.startDate ? new Date(filters.startDate) : undefined;
        const end = filters.endDate ? new Date(filters.endDate) : undefined;
        if (start && Number.isNaN(start.getTime())) {
            throw new common_1.BadRequestException("startDate must be a valid ISO date");
        }
        if (end && Number.isNaN(end.getTime())) {
            throw new common_1.BadRequestException("endDate must be a valid ISO date");
        }
        if (start && end && start > end) {
            throw new common_1.BadRequestException("startDate must be before endDate");
        }
        return { start, end };
    }
    buildDateWhere(field, range) {
        const condition = this.createDateCondition(range.start, range.end);
        if (!condition) {
            return undefined;
        }
        return { [field]: condition };
    }
    createDateCondition(start, end) {
        if (start && end) {
            return (0, typeorm_2.Between)(start, end);
        }
        if (start) {
            return (0, typeorm_2.MoreThanOrEqual)(start);
        }
        if (end) {
            return (0, typeorm_2.LessThanOrEqual)(end);
        }
        return undefined;
    }
};
exports.DashboardService = DashboardService;
exports.DashboardService = DashboardService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(supplier_product_entity_1.SupplierProduct)),
    __param(1, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(2, (0, typeorm_1.InjectRepository)(customer_entity_1.Customer)),
    __param(3, (0, typeorm_1.InjectRepository)(order_return_entity_1.OrderReturn)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], DashboardService);
//# sourceMappingURL=dashboard.service.js.map