"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Product = void 0;
const typeorm_1 = require("typeorm");
const supplier_product_entity_1 = require("./supplier-product.entity");
const purchase_order_item_entity_1 = require("./purchase-order-item.entity");
const order_item_entity_1 = require("./order-item.entity");
const stock_entity_1 = require("./stock.entity");
const category_entity_1 = require("./category.entity");
const size_entity_1 = require("./size.entity");
const color_entity_1 = require("./color.entity");
let Product = class Product {
    id;
    product_code;
    product_name;
    product_color;
    description;
    created_at;
    category;
    supplierProducts;
    purchaseOrderItems;
    orderItems;
    stocks;
    sizes;
    colors;
};
exports.Product = Product;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Product.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ unique: true }),
    __metadata("design:type", String)
], Product.prototype, "product_code", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Product.prototype, "product_name", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], Product.prototype, "product_color", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], Product.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Product.prototype, "created_at", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => category_entity_1.Category, (category) => category.products, {
        nullable: true,
        onDelete: "SET NULL",
    }),
    (0, typeorm_1.JoinColumn)({ name: "category_id" }),
    __metadata("design:type", Object)
], Product.prototype, "category", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => supplier_product_entity_1.SupplierProduct, (supplierProduct) => supplierProduct.product),
    __metadata("design:type", Array)
], Product.prototype, "supplierProducts", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => purchase_order_item_entity_1.PurchaseOrderItem, (purchaseOrderItem) => purchaseOrderItem.product),
    __metadata("design:type", Array)
], Product.prototype, "purchaseOrderItems", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => order_item_entity_1.OrderItem, (orderItem) => orderItem.product),
    __metadata("design:type", Array)
], Product.prototype, "orderItems", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => stock_entity_1.Stock, (stock) => stock.product),
    __metadata("design:type", Array)
], Product.prototype, "stocks", void 0);
__decorate([
    (0, typeorm_1.ManyToMany)(() => size_entity_1.Size, (size) => size.products, { eager: false }),
    (0, typeorm_1.JoinTable)({
        name: "product_sizes",
        joinColumn: { name: "product_id", referencedColumnName: "id" },
        inverseJoinColumn: { name: "size_id", referencedColumnName: "id" },
    }),
    __metadata("design:type", Array)
], Product.prototype, "sizes", void 0);
__decorate([
    (0, typeorm_1.ManyToMany)(() => color_entity_1.Color, (color) => color.products, { eager: false }),
    (0, typeorm_1.JoinTable)({
        name: "product_colors",
        joinColumn: { name: "product_id", referencedColumnName: "id" },
        inverseJoinColumn: { name: "color_id", referencedColumnName: "id" },
    }),
    __metadata("design:type", Array)
], Product.prototype, "colors", void 0);
exports.Product = Product = __decorate([
    (0, typeorm_1.Entity)("products")
], Product);
//# sourceMappingURL=product.entity.js.map