"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stock = void 0;
const typeorm_1 = require("typeorm");
const product_entity_1 = require("./product.entity");
const stock_movement_entity_1 = require("./stock-movement.entity");
const size_entity_1 = require("./size.entity");
const color_entity_1 = require("./color.entity");
let Stock = class Stock {
    id;
    product;
    size_id;
    size;
    quantity;
    color_id;
    color;
    created_at;
    updated_at;
    movements;
};
exports.Stock = Stock;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Stock.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => product_entity_1.Product, (product) => product.stocks, {
        onDelete: "CASCADE",
    }),
    (0, typeorm_1.JoinColumn)({ name: "product_id" }),
    __metadata("design:type", product_entity_1.Product)
], Stock.prototype, "product", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "size_id" }),
    __metadata("design:type", Number)
], Stock.prototype, "size_id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => size_entity_1.Size, (size) => size.stocks, {
        onDelete: "RESTRICT",
    }),
    (0, typeorm_1.JoinColumn)({ name: "size_id" }),
    __metadata("design:type", size_entity_1.Size)
], Stock.prototype, "size", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "int", default: 0 }),
    __metadata("design:type", Number)
], Stock.prototype, "quantity", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "color_id", nullable: true }),
    __metadata("design:type", Object)
], Stock.prototype, "color_id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => color_entity_1.Color, (color) => color.stocks, {
        onDelete: "RESTRICT",
        nullable: true,
    }),
    (0, typeorm_1.JoinColumn)({ name: "color_id" }),
    __metadata("design:type", Object)
], Stock.prototype, "color", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Stock.prototype, "created_at", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], Stock.prototype, "updated_at", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => stock_movement_entity_1.StockMovement, (movement) => movement.stock),
    __metadata("design:type", Array)
], Stock.prototype, "movements", void 0);
exports.Stock = Stock = __decorate([
    (0, typeorm_1.Entity)("stocks"),
    (0, typeorm_1.Unique)("UQ_stock_product_size_color", ["product", "size", "color"])
], Stock);
//# sourceMappingURL=stock.entity.js.map