import { Supplier } from "./supplier.entity";
import { Product } from "./product.entity";
import { SupplierProductRestockLog } from "./supplier-product-restock-log.entity";
import { SupplierProductSize } from "./supplier-product-size.entity";
import { Color } from "./color.entity";
export type SupplierProductStatus = "preorder" | "completed";
export declare class SupplierProduct {
    id: number;
    supplier_id: number;
    product_id: number;
    unit_price: number;
    quantity: number;
    color_id: number | null;
    color: Color | null;
    status: SupplierProductStatus;
    note: string | null;
    purchase_date: Date | null;
    created_at: Date;
    supplier: Supplier;
    product: Product;
    restockLogs: SupplierProductRestockLog[];
    sizes: SupplierProductSize[];
}
