"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierProduct = void 0;
const typeorm_1 = require("typeorm");
const swagger_1 = require("@nestjs/swagger");
const supplier_entity_1 = require("./supplier.entity");
const product_entity_1 = require("./product.entity");
const supplier_product_restock_log_entity_1 = require("./supplier-product-restock-log.entity");
const supplier_product_size_entity_1 = require("./supplier-product-size.entity");
const color_entity_1 = require("./color.entity");
let SupplierProduct = class SupplierProduct {
    id;
    supplier_id;
    product_id;
    unit_price;
    quantity;
    color_id;
    color;
    status;
    note;
    purchase_date;
    created_at;
    supplier;
    product;
    restockLogs;
    sizes;
};
exports.SupplierProduct = SupplierProduct;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], SupplierProduct.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], SupplierProduct.prototype, "supplier_id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], SupplierProduct.prototype, "product_id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "decimal", precision: 10, scale: 2 }),
    __metadata("design:type", Number)
], SupplierProduct.prototype, "unit_price", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], SupplierProduct.prototype, "quantity", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "color_id", nullable: true }),
    __metadata("design:type", Object)
], SupplierProduct.prototype, "color_id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => color_entity_1.Color, (color) => color.supplierProducts, {
        nullable: true,
        onDelete: "SET NULL",
    }),
    (0, typeorm_1.JoinColumn)({ name: "color_id" }),
    __metadata("design:type", Object)
], SupplierProduct.prototype, "color", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "enum",
        enum: ["preorder", "completed"],
        default: "completed",
    }),
    __metadata("design:type", String)
], SupplierProduct.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "varchar", length: 50, nullable: true }),
    __metadata("design:type", Object)
], SupplierProduct.prototype, "note", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "The date when the supplier fulfilled this product purchase",
        type: String,
        format: "date",
        required: false,
        nullable: true,
        example: "2024-03-01",
    }),
    (0, typeorm_1.Column)({ type: "date", nullable: true }),
    __metadata("design:type", Object)
], SupplierProduct.prototype, "purchase_date", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], SupplierProduct.prototype, "created_at", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => supplier_entity_1.Supplier, (supplier) => supplier.supplierProducts),
    (0, typeorm_1.JoinColumn)({ name: "supplier_id" }),
    __metadata("design:type", supplier_entity_1.Supplier)
], SupplierProduct.prototype, "supplier", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => product_entity_1.Product, (product) => product.supplierProducts),
    (0, typeorm_1.JoinColumn)({ name: "product_id" }),
    __metadata("design:type", product_entity_1.Product)
], SupplierProduct.prototype, "product", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => supplier_product_restock_log_entity_1.SupplierProductRestockLog, (restockLog) => restockLog.supplierProduct),
    __metadata("design:type", Array)
], SupplierProduct.prototype, "restockLogs", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => supplier_product_size_entity_1.SupplierProductSize, (supplierProductSize) => supplierProductSize.supplierProduct, { cascade: true }),
    __metadata("design:type", Array)
], SupplierProduct.prototype, "sizes", void 0);
exports.SupplierProduct = SupplierProduct = __decorate([
    (0, typeorm_1.Entity)("supplier_products")
], SupplierProduct);
//# sourceMappingURL=supplier-product.entity.js.map