"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateUsers1761482133105 = void 0;
class CreateUsers1761482133105 {
    name = 'CreateUsers1761482133105';
    async up(queryRunner) {
        await queryRunner.query(`CREATE TABLE \`users\` (\`id\` int NOT NULL AUTO_INCREMENT, \`name\` varchar(255) NOT NULL, \`email\` varchar(255) NOT NULL, \`phone\` varchar(255) NULL, \`status\` tinyint NOT NULL DEFAULT '1', \`password\` varchar(255) NOT NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), UNIQUE INDEX \`IDX_97672ac88f789774dd47f7c8be\` (\`email\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`purchase_orders\` (\`id\` int NOT NULL AUTO_INCREMENT, \`supplier_id\` int NOT NULL, \`order_date\` date NOT NULL, \`total_amount\` decimal(10,2) NOT NULL DEFAULT '0.00', \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`stock_movements\` (\`id\` int NOT NULL AUTO_INCREMENT, \`movement_type\` enum ('NEW', 'SALE', 'RETURN') NOT NULL, \`quantity\` int NOT NULL, \`reference_type\` varchar(50) NULL, \`reference_id\` int NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`stock_id\` int NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`supplier_product_sizes\` (\`id\` int NOT NULL AUTO_INCREMENT, \`supplier_product_id\` int NOT NULL, \`size_id\` int NOT NULL, \`quantity\` int NOT NULL, \`color_id\` int NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`colors\` (\`id\` int NOT NULL AUTO_INCREMENT, \`name\` varchar(255) NOT NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), UNIQUE INDEX \`IDX_cf12321fa0b7b9539e89c7dfeb\` (\`name\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`stocks\` (\`id\` int NOT NULL AUTO_INCREMENT, \`size_id\` int NOT NULL, \`quantity\` int NOT NULL DEFAULT '0', \`color_id\` int NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`product_id\` int NULL, UNIQUE INDEX \`UQ_stock_product_size_color\` (\`product_id\`, \`size_id\`, \`color_id\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`customers\` (\`id\` int NOT NULL AUTO_INCREMENT, \`first_name\` varchar(255) NOT NULL, \`email\` varchar(255) NOT NULL, \`last_name\` varchar(255) NOT NULL, \`phone\` varchar(32) NULL, \`address\` text NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), UNIQUE INDEX \`IDX_8536b8b85c06969f84f0c098b0\` (\`email\`), UNIQUE INDEX \`IDX_88acd889fbe17d0e16cc4bc917\` (\`phone\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`order_return_items\` (\`id\` int NOT NULL AUTO_INCREMENT, \`quantity\` int NOT NULL, \`amount\` decimal(12,2) NOT NULL, \`order_return_id\` int NULL, \`order_item_id\` int NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`order_returns\` (\`id\` int NOT NULL AUTO_INCREMENT, \`total_amount\` decimal(12,2) NOT NULL, \`reason\` text NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`order_id\` int NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`orders\` (\`id\` int NOT NULL AUTO_INCREMENT, \`order_code\` varchar(255) NOT NULL, \`order_date\` datetime NOT NULL, \`status\` varchar(255) NOT NULL DEFAULT 'pending', \`total_amount\` decimal(12,2) NOT NULL DEFAULT '0.00', \`refunded_amount\` decimal(12,2) NOT NULL DEFAULT '0.00', \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`customer_id\` int NOT NULL, UNIQUE INDEX \`IDX_e462c2f2237b3049aa6be3fce0\` (\`order_code\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`order_items\` (\`id\` int NOT NULL AUTO_INCREMENT, \`size_id\` int NOT NULL, \`quantity\` int NOT NULL, \`returned_quantity\` int NOT NULL DEFAULT '0', \`unit_price\` decimal(12,2) NOT NULL, \`line_total\` decimal(12,2) NOT NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`order_id\` int NULL, \`product_id\` int NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`sizes\` (\`id\` int NOT NULL AUTO_INCREMENT, \`name\` varchar(255) NOT NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), UNIQUE INDEX \`IDX_9fc6e663546e7a6cfdc465e86d\` (\`name\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`purchase_order_items\` (\`id\` int NOT NULL AUTO_INCREMENT, \`order_id\` int NOT NULL, \`product_id\` int NOT NULL, \`size_id\` int NOT NULL, \`quantity\` int NOT NULL, \`unit_price\` decimal(10,2) NOT NULL, \`total\` decimal(10,2) NOT NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`categories\` (\`id\` int NOT NULL AUTO_INCREMENT, \`category_name\` varchar(255) NOT NULL, \`title\` varchar(255) NULL, \`subtitle\` varchar(255) NULL, \`status\` tinyint NOT NULL DEFAULT '1', \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updated_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`parent_id\` int NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`products\` (\`id\` int NOT NULL AUTO_INCREMENT, \`product_code\` varchar(255) NOT NULL, \`product_name\` varchar(255) NOT NULL, \`product_color\` text NULL, \`description\` text NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`category_id\` int NULL, UNIQUE INDEX \`IDX_70b3f77ca8de13149b7f08d725\` (\`product_code\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`supplier_product_restock_logs\` (\`id\` int NOT NULL AUTO_INCREMENT, \`supplier_product_id\` int NOT NULL, \`quantity\` int NOT NULL, \`unit_price\` decimal(10,2) NULL, \`restocked_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`supplier_products\` (\`id\` int NOT NULL AUTO_INCREMENT, \`supplier_id\` int NOT NULL, \`product_id\` int NOT NULL, \`unit_price\` decimal(10,2) NOT NULL, \`quantity\` int NOT NULL, \`color_id\` int NULL, \`status\` enum ('preorder', 'completed') NOT NULL DEFAULT 'completed', \`note\` varchar(50) NULL, \`purchase_date\` date NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`suppliers\` (\`id\` int NOT NULL AUTO_INCREMENT, \`name\` varchar(255) NOT NULL, \`email\` varchar(255) NOT NULL, \`address\` varchar(255) NULL, \`phone\` varchar(255) NULL, \`created_at\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), UNIQUE INDEX \`IDX_66181e465a65c2ddcfa9c00c9c\` (\`email\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`product_sizes\` (\`product_id\` int NOT NULL, \`size_id\` int NOT NULL, INDEX \`IDX_b6d94a689dd115cdf01589b961\` (\`product_id\`), INDEX \`IDX_b77c486737027396bcfdc0897b\` (\`size_id\`), PRIMARY KEY (\`product_id\`, \`size_id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`product_colors\` (\`product_id\` int NOT NULL, \`color_id\` int NOT NULL, INDEX \`IDX_90213070102b149edd87ab1207\` (\`product_id\`), INDEX \`IDX_ab5fd8f7c7e066c3126f6ac280\` (\`color_id\`), PRIMARY KEY (\`product_id\`, \`color_id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`ALTER TABLE \`purchase_orders\` ADD CONSTRAINT \`FK_d16a885aa88447ccfd010e739b0\` FOREIGN KEY (\`supplier_id\`) REFERENCES \`suppliers\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`stock_movements\` ADD CONSTRAINT \`FK_fe1f8086b016f319c4f7f389602\` FOREIGN KEY (\`stock_id\`) REFERENCES \`stocks\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`supplier_product_sizes\` ADD CONSTRAINT \`FK_2a9c02d16d819655fddbac7353a\` FOREIGN KEY (\`color_id\`) REFERENCES \`colors\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`supplier_product_sizes\` ADD CONSTRAINT \`FK_b9ad070275ec3f0dde13e40cb6d\` FOREIGN KEY (\`supplier_product_id\`) REFERENCES \`supplier_products\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`supplier_product_sizes\` ADD CONSTRAINT \`FK_7e9dea641f9aef347a67b7bb527\` FOREIGN KEY (\`size_id\`) REFERENCES \`sizes\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`stocks\` ADD CONSTRAINT \`FK_cdcdc9a4b531cbd24c06bc4f9e7\` FOREIGN KEY (\`product_id\`) REFERENCES \`products\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`stocks\` ADD CONSTRAINT \`FK_72ee7e143c791a4bf76a7cbab5f\` FOREIGN KEY (\`size_id\`) REFERENCES \`sizes\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`stocks\` ADD CONSTRAINT \`FK_f1006e10c0c45c4e121b46b8a98\` FOREIGN KEY (\`color_id\`) REFERENCES \`colors\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`order_return_items\` ADD CONSTRAINT \`FK_83305ff274073c397214d8805d2\` FOREIGN KEY (\`order_return_id\`) REFERENCES \`order_returns\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`order_return_items\` ADD CONSTRAINT \`FK_eae12aa6834fffd313614e6f006\` FOREIGN KEY (\`order_item_id\`) REFERENCES \`order_items\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`order_returns\` ADD CONSTRAINT \`FK_bcd8e1a275860e70f3a876d718f\` FOREIGN KEY (\`order_id\`) REFERENCES \`orders\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`orders\` ADD CONSTRAINT \`FK_772d0ce0473ac2ccfa26060dbe9\` FOREIGN KEY (\`customer_id\`) REFERENCES \`customers\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`order_items\` ADD CONSTRAINT \`FK_145532db85752b29c57d2b7b1f1\` FOREIGN KEY (\`order_id\`) REFERENCES \`orders\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`order_items\` ADD CONSTRAINT \`FK_9263386c35b6b242540f9493b00\` FOREIGN KEY (\`product_id\`) REFERENCES \`products\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`order_items\` ADD CONSTRAINT \`FK_0b0a262143ce8403f03ba2e9e57\` FOREIGN KEY (\`size_id\`) REFERENCES \`sizes\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`purchase_order_items\` ADD CONSTRAINT \`FK_d280ebc9ce8644e7fbe6abda7c2\` FOREIGN KEY (\`size_id\`) REFERENCES \`sizes\`(\`id\`) ON DELETE RESTRICT ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`purchase_order_items\` ADD CONSTRAINT \`FK_c133e834562c02eb4061813938f\` FOREIGN KEY (\`order_id\`) REFERENCES \`purchase_orders\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`purchase_order_items\` ADD CONSTRAINT \`FK_d5089517fc19b1b9fb04454740c\` FOREIGN KEY (\`product_id\`) REFERENCES \`products\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`categories\` ADD CONSTRAINT \`FK_88cea2dc9c31951d06437879b40\` FOREIGN KEY (\`parent_id\`) REFERENCES \`categories\`(\`id\`) ON DELETE SET NULL ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`products\` ADD CONSTRAINT \`FK_9a5f6868c96e0069e699f33e124\` FOREIGN KEY (\`category_id\`) REFERENCES \`categories\`(\`id\`) ON DELETE SET NULL ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`supplier_product_restock_logs\` ADD CONSTRAINT \`FK_b76ca8c55e50c7301c5671c96f8\` FOREIGN KEY (\`supplier_product_id\`) REFERENCES \`supplier_products\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`supplier_products\` ADD CONSTRAINT \`FK_942f238e9baf3eedf8c2ab6def6\` FOREIGN KEY (\`color_id\`) REFERENCES \`colors\`(\`id\`) ON DELETE SET NULL ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`supplier_products\` ADD CONSTRAINT \`FK_4286173e1486a5c528f89dc798c\` FOREIGN KEY (\`supplier_id\`) REFERENCES \`suppliers\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`supplier_products\` ADD CONSTRAINT \`FK_9ff2b133160a708a047cbce49d2\` FOREIGN KEY (\`product_id\`) REFERENCES \`products\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`product_sizes\` ADD CONSTRAINT \`FK_b6d94a689dd115cdf01589b9615\` FOREIGN KEY (\`product_id\`) REFERENCES \`products\`(\`id\`) ON DELETE CASCADE ON UPDATE CASCADE`);
        await queryRunner.query(`ALTER TABLE \`product_sizes\` ADD CONSTRAINT \`FK_b77c486737027396bcfdc0897bf\` FOREIGN KEY (\`size_id\`) REFERENCES \`sizes\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`product_colors\` ADD CONSTRAINT \`FK_90213070102b149edd87ab1207e\` FOREIGN KEY (\`product_id\`) REFERENCES \`products\`(\`id\`) ON DELETE CASCADE ON UPDATE CASCADE`);
        await queryRunner.query(`ALTER TABLE \`product_colors\` ADD CONSTRAINT \`FK_ab5fd8f7c7e066c3126f6ac280b\` FOREIGN KEY (\`color_id\`) REFERENCES \`colors\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
    }
    async down(queryRunner) {
        await queryRunner.query(`ALTER TABLE \`product_colors\` DROP FOREIGN KEY \`FK_ab5fd8f7c7e066c3126f6ac280b\``);
        await queryRunner.query(`ALTER TABLE \`product_colors\` DROP FOREIGN KEY \`FK_90213070102b149edd87ab1207e\``);
        await queryRunner.query(`ALTER TABLE \`product_sizes\` DROP FOREIGN KEY \`FK_b77c486737027396bcfdc0897bf\``);
        await queryRunner.query(`ALTER TABLE \`product_sizes\` DROP FOREIGN KEY \`FK_b6d94a689dd115cdf01589b9615\``);
        await queryRunner.query(`ALTER TABLE \`supplier_products\` DROP FOREIGN KEY \`FK_9ff2b133160a708a047cbce49d2\``);
        await queryRunner.query(`ALTER TABLE \`supplier_products\` DROP FOREIGN KEY \`FK_4286173e1486a5c528f89dc798c\``);
        await queryRunner.query(`ALTER TABLE \`supplier_products\` DROP FOREIGN KEY \`FK_942f238e9baf3eedf8c2ab6def6\``);
        await queryRunner.query(`ALTER TABLE \`supplier_product_restock_logs\` DROP FOREIGN KEY \`FK_b76ca8c55e50c7301c5671c96f8\``);
        await queryRunner.query(`ALTER TABLE \`products\` DROP FOREIGN KEY \`FK_9a5f6868c96e0069e699f33e124\``);
        await queryRunner.query(`ALTER TABLE \`categories\` DROP FOREIGN KEY \`FK_88cea2dc9c31951d06437879b40\``);
        await queryRunner.query(`ALTER TABLE \`purchase_order_items\` DROP FOREIGN KEY \`FK_d5089517fc19b1b9fb04454740c\``);
        await queryRunner.query(`ALTER TABLE \`purchase_order_items\` DROP FOREIGN KEY \`FK_c133e834562c02eb4061813938f\``);
        await queryRunner.query(`ALTER TABLE \`purchase_order_items\` DROP FOREIGN KEY \`FK_d280ebc9ce8644e7fbe6abda7c2\``);
        await queryRunner.query(`ALTER TABLE \`order_items\` DROP FOREIGN KEY \`FK_0b0a262143ce8403f03ba2e9e57\``);
        await queryRunner.query(`ALTER TABLE \`order_items\` DROP FOREIGN KEY \`FK_9263386c35b6b242540f9493b00\``);
        await queryRunner.query(`ALTER TABLE \`order_items\` DROP FOREIGN KEY \`FK_145532db85752b29c57d2b7b1f1\``);
        await queryRunner.query(`ALTER TABLE \`orders\` DROP FOREIGN KEY \`FK_772d0ce0473ac2ccfa26060dbe9\``);
        await queryRunner.query(`ALTER TABLE \`order_returns\` DROP FOREIGN KEY \`FK_bcd8e1a275860e70f3a876d718f\``);
        await queryRunner.query(`ALTER TABLE \`order_return_items\` DROP FOREIGN KEY \`FK_eae12aa6834fffd313614e6f006\``);
        await queryRunner.query(`ALTER TABLE \`order_return_items\` DROP FOREIGN KEY \`FK_83305ff274073c397214d8805d2\``);
        await queryRunner.query(`ALTER TABLE \`stocks\` DROP FOREIGN KEY \`FK_f1006e10c0c45c4e121b46b8a98\``);
        await queryRunner.query(`ALTER TABLE \`stocks\` DROP FOREIGN KEY \`FK_72ee7e143c791a4bf76a7cbab5f\``);
        await queryRunner.query(`ALTER TABLE \`stocks\` DROP FOREIGN KEY \`FK_cdcdc9a4b531cbd24c06bc4f9e7\``);
        await queryRunner.query(`ALTER TABLE \`supplier_product_sizes\` DROP FOREIGN KEY \`FK_7e9dea641f9aef347a67b7bb527\``);
        await queryRunner.query(`ALTER TABLE \`supplier_product_sizes\` DROP FOREIGN KEY \`FK_b9ad070275ec3f0dde13e40cb6d\``);
        await queryRunner.query(`ALTER TABLE \`supplier_product_sizes\` DROP FOREIGN KEY \`FK_2a9c02d16d819655fddbac7353a\``);
        await queryRunner.query(`ALTER TABLE \`stock_movements\` DROP FOREIGN KEY \`FK_fe1f8086b016f319c4f7f389602\``);
        await queryRunner.query(`ALTER TABLE \`purchase_orders\` DROP FOREIGN KEY \`FK_d16a885aa88447ccfd010e739b0\``);
        await queryRunner.query(`DROP INDEX \`IDX_ab5fd8f7c7e066c3126f6ac280\` ON \`product_colors\``);
        await queryRunner.query(`DROP INDEX \`IDX_90213070102b149edd87ab1207\` ON \`product_colors\``);
        await queryRunner.query(`DROP TABLE \`product_colors\``);
        await queryRunner.query(`DROP INDEX \`IDX_b77c486737027396bcfdc0897b\` ON \`product_sizes\``);
        await queryRunner.query(`DROP INDEX \`IDX_b6d94a689dd115cdf01589b961\` ON \`product_sizes\``);
        await queryRunner.query(`DROP TABLE \`product_sizes\``);
        await queryRunner.query(`DROP INDEX \`IDX_66181e465a65c2ddcfa9c00c9c\` ON \`suppliers\``);
        await queryRunner.query(`DROP TABLE \`suppliers\``);
        await queryRunner.query(`DROP TABLE \`supplier_products\``);
        await queryRunner.query(`DROP TABLE \`supplier_product_restock_logs\``);
        await queryRunner.query(`DROP INDEX \`IDX_70b3f77ca8de13149b7f08d725\` ON \`products\``);
        await queryRunner.query(`DROP TABLE \`products\``);
        await queryRunner.query(`DROP TABLE \`categories\``);
        await queryRunner.query(`DROP TABLE \`purchase_order_items\``);
        await queryRunner.query(`DROP INDEX \`IDX_9fc6e663546e7a6cfdc465e86d\` ON \`sizes\``);
        await queryRunner.query(`DROP TABLE \`sizes\``);
        await queryRunner.query(`DROP TABLE \`order_items\``);
        await queryRunner.query(`DROP INDEX \`IDX_e462c2f2237b3049aa6be3fce0\` ON \`orders\``);
        await queryRunner.query(`DROP TABLE \`orders\``);
        await queryRunner.query(`DROP TABLE \`order_returns\``);
        await queryRunner.query(`DROP TABLE \`order_return_items\``);
        await queryRunner.query(`DROP INDEX \`IDX_88acd889fbe17d0e16cc4bc917\` ON \`customers\``);
        await queryRunner.query(`DROP INDEX \`IDX_8536b8b85c06969f84f0c098b0\` ON \`customers\``);
        await queryRunner.query(`DROP TABLE \`customers\``);
        await queryRunner.query(`DROP INDEX \`UQ_stock_product_size_color\` ON \`stocks\``);
        await queryRunner.query(`DROP TABLE \`stocks\``);
        await queryRunner.query(`DROP INDEX \`IDX_cf12321fa0b7b9539e89c7dfeb\` ON \`colors\``);
        await queryRunner.query(`DROP TABLE \`colors\``);
        await queryRunner.query(`DROP TABLE \`supplier_product_sizes\``);
        await queryRunner.query(`DROP TABLE \`stock_movements\``);
        await queryRunner.query(`DROP TABLE \`purchase_orders\``);
        await queryRunner.query(`DROP INDEX \`IDX_97672ac88f789774dd47f7c8be\` ON \`users\``);
        await queryRunner.query(`DROP TABLE \`users\``);
    }
}
exports.CreateUsers1761482133105 = CreateUsers1761482133105;
//# sourceMappingURL=1761482133105-createUsers.js.map