import { OrderService } from "./order.service";
import { CreateOrderDto } from "./dto/create-order.dto";
import { UpdateOrderStatusDto } from "./dto/update-order-status.dto";
import { CreateOrderReturnDto } from "./dto/create-order-return.dto";
import { PaginationDto } from "../common/dto/pagination.dto";
export declare class OrderController {
    private readonly orderService;
    constructor(orderService: OrderService);
    create(createOrderDto: CreateOrderDto): Promise<import("../entities/order.entity").Order>;
    findAll(paginationDto: PaginationDto): Promise<{
        data: import("../entities/order.entity").Order[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    findOne(id: string): Promise<import("../entities/order.entity").Order>;
    updateStatus(id: string, updateOrderStatusDto: UpdateOrderStatusDto): Promise<import("../entities/order.entity").Order>;
    createReturn(id: string, createOrderReturnDto: CreateOrderReturnDto): Promise<import("../entities/order.entity").Order>;
    remove(id: string): Promise<void>;
}
