"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const order_service_1 = require("./order.service");
const create_order_dto_1 = require("./dto/create-order.dto");
const update_order_status_dto_1 = require("./dto/update-order-status.dto");
const create_order_return_dto_1 = require("./dto/create-order-return.dto");
const pagination_dto_1 = require("../common/dto/pagination.dto");
let OrderController = class OrderController {
    orderService;
    constructor(orderService) {
        this.orderService = orderService;
    }
    create(createOrderDto) {
        return this.orderService.create(createOrderDto);
    }
    findAll(paginationDto) {
        return this.orderService.findAll(paginationDto);
    }
    findOne(id) {
        return this.orderService.findOne(+id);
    }
    updateStatus(id, updateOrderStatusDto) {
        return this.orderService.updateStatus(+id, updateOrderStatusDto);
    }
    createReturn(id, createOrderReturnDto) {
        return this.orderService.createReturn(+id, createOrderReturnDto);
    }
    remove(id) {
        return this.orderService.remove(+id);
    }
};
exports.OrderController = OrderController;
__decorate([
    (0, common_1.Post)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.CREATED),
    (0, swagger_1.ApiOperation)({ summary: "Create a new sales order" }),
    (0, swagger_1.ApiBody)({ type: create_order_dto_1.CreateOrderDto }),
    (0, swagger_1.ApiResponse)({ status: 201, description: "Order has been created." }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Validation failed." }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_order_dto_1.CreateOrderDto]),
    __metadata("design:returntype", void 0)
], OrderController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({
        summary: "List orders with pagination and optional search filter",
    }),
    (0, swagger_1.ApiResponse)({ status: 200, description: "Returns paginated orders." }),
    (0, swagger_1.ApiQuery)({
        name: "limit",
        type: Number,
        required: false,
        description: "Maximum number of orders per page",
    }),
    (0, swagger_1.ApiQuery)({
        name: "page",
        type: Number,
        required: false,
        description: "Page number to retrieve",
    }),
    (0, swagger_1.ApiQuery)({
        name: "search",
        type: String,
        required: false,
        description: "Search keyword applied to order code, status, or customer fields",
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_dto_1.PaginationDto]),
    __metadata("design:returntype", void 0)
], OrderController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Get an order by ID" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Order identifier" }),
    (0, swagger_1.ApiResponse)({ status: 200, description: "Returns the requested order." }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Order not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrderController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(":id/status"),
    (0, swagger_1.ApiOperation)({ summary: "Update order status" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Order identifier" }),
    (0, swagger_1.ApiBody)({ type: update_order_status_dto_1.UpdateOrderStatusDto }),
    (0, swagger_1.ApiResponse)({ status: 200, description: "Order status updated." }),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_order_status_dto_1.UpdateOrderStatusDto]),
    __metadata("design:returntype", void 0)
], OrderController.prototype, "updateStatus", null);
__decorate([
    (0, common_1.Post)(":id/returns"),
    (0, common_1.HttpCode)(common_1.HttpStatus.CREATED),
    (0, swagger_1.ApiOperation)({ summary: "Create a return for an order" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Order identifier" }),
    (0, swagger_1.ApiBody)({ type: create_order_return_dto_1.CreateOrderReturnDto }),
    (0, swagger_1.ApiResponse)({ status: 201, description: "Order return processed." }),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, create_order_return_dto_1.CreateOrderReturnDto]),
    __metadata("design:returntype", void 0)
], OrderController.prototype, "createReturn", null);
__decorate([
    (0, common_1.Delete)(":id"),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, swagger_1.ApiOperation)({ summary: "Delete an order" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Order identifier" }),
    (0, swagger_1.ApiResponse)({ status: 204, description: "Order deleted." }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Order not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrderController.prototype, "remove", null);
exports.OrderController = OrderController = __decorate([
    (0, swagger_1.ApiTags)("Orders"),
    (0, common_1.Controller)("orders"),
    __metadata("design:paramtypes", [order_service_1.OrderService])
], OrderController);
//# sourceMappingURL=order.controller.js.map