import { DataSource, Repository } from "typeorm";
import { Order } from "../entities/order.entity";
import { CreateOrderDto } from "./dto/create-order.dto";
import { UpdateOrderStatusDto } from "./dto/update-order-status.dto";
import { CreateOrderReturnDto } from "./dto/create-order-return.dto";
import { StockService } from "../stock/stock.service";
import { PaginationDto } from "../common/dto/pagination.dto";
export declare class OrderService {
    private readonly orderRepository;
    private readonly dataSource;
    private readonly stockService;
    constructor(orderRepository: Repository<Order>, dataSource: DataSource, stockService: StockService);
    findAll(paginationDto: PaginationDto): Promise<{
        data: Order[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    findOne(id: number): Promise<Order>;
    create(createOrderDto: CreateOrderDto): Promise<Order>;
    updateStatus(id: number, updateOrderStatusDto: UpdateOrderStatusDto): Promise<Order>;
    createReturn(orderId: number, createOrderReturnDto: CreateOrderReturnDto): Promise<Order>;
    remove(id: number): Promise<void>;
    private getOrderByIdOrFail;
    private generateOrderCode;
}
