import { Repository } from "typeorm";
import { Product } from "../entities/product.entity";
import { Category } from "../entities/category.entity";
import { PaginationDto } from "../common/dto/pagination.dto";
import { CreateProductDto } from "./dto/create-product.dto";
import { UpdateProductDto } from "./dto/update-product.dto";
import { Size } from "../entities/size.entity";
import { Color } from "../entities/color.entity";
export declare class ProductService {
    private readonly productRepository;
    private readonly categoryRepository;
    private readonly sizeRepository;
    private readonly colorRepository;
    constructor(productRepository: Repository<Product>, categoryRepository: Repository<Category>, sizeRepository: Repository<Size>, colorRepository: Repository<Color>);
    create(createProductDto: CreateProductDto): Promise<Product>;
    findAll(paginationDto: PaginationDto): Promise<{
        data: Product[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    findOne(id: number): Promise<Product>;
    update(id: number, updateProductDto: UpdateProductDto): Promise<Product>;
    remove(id: number): Promise<void>;
    private resolveCategory;
    private resolveSizes;
    private resolveColors;
}
