"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const product_entity_1 = require("../entities/product.entity");
const category_entity_1 = require("../entities/category.entity");
const size_entity_1 = require("../entities/size.entity");
const color_entity_1 = require("../entities/color.entity");
let ProductService = class ProductService {
    productRepository;
    categoryRepository;
    sizeRepository;
    colorRepository;
    constructor(productRepository, categoryRepository, sizeRepository, colorRepository) {
        this.productRepository = productRepository;
        this.categoryRepository = categoryRepository;
        this.sizeRepository = sizeRepository;
        this.colorRepository = colorRepository;
    }
    async create(createProductDto) {
        const { categoryId, sizeIds, colorIds, ...productData } = createProductDto;
        const category = await this.resolveCategory(categoryId);
        const sizes = await this.resolveSizes(sizeIds);
        const colors = await this.resolveColors(colorIds ?? []);
        const product = this.productRepository.create({
            ...productData,
            category: category ?? null,
            sizes,
            colors,
        });
        return this.productRepository.save(product);
    }
    async findAll(paginationDto) {
        const page = Math.max(Number.parseInt(paginationDto.page ?? "1", 10) || 1, 1);
        const limit = Math.max(Number.parseInt(paginationDto.limit ?? "10", 10) || 10, 1);
        const search = paginationDto.search?.trim() ?? "";
        const queryBuilder = this.productRepository
            .createQueryBuilder("product")
            .leftJoinAndSelect("product.category", "category")
            .leftJoinAndSelect("product.sizes", "size")
            .leftJoinAndSelect("product.colors", "color")
            .distinct(true);
        if (search) {
            queryBuilder.where("(LOWER(product.product_name) LIKE LOWER(:search) OR LOWER(product.product_code) LIKE LOWER(:search) OR LOWER(product.product_color) LIKE LOWER(:search) OR LOWER(size.name) LIKE LOWER(:search) OR LOWER(color.name) LIKE LOWER(:search))", { search: `%${search}%` });
        }
        queryBuilder.orderBy("product.created_at", "DESC");
        const [data, total] = await queryBuilder
            .skip((page - 1) * limit)
            .take(limit)
            .getManyAndCount();
        const totalPages = total > 0 ? Math.ceil(total / limit) : 0;
        return {
            data,
            page,
            limit,
            total,
            previous: page > 1 ? page - 1 : null,
            next: page < totalPages ? page + 1 : null,
        };
    }
    async findOne(id) {
        const product = await this.productRepository.findOne({
            where: { id },
            relations: ["category", "sizes", "colors"],
        });
        if (!product) {
            throw new common_1.NotFoundException(`Product with ID ${id} not found`);
        }
        return product;
    }
    async update(id, updateProductDto) {
        const product = await this.findOne(id);
        const { categoryId, sizeIds, colorIds, ...productData } = updateProductDto;
        if (categoryId !== undefined) {
            product.category = await this.resolveCategory(categoryId);
        }
        if (sizeIds !== undefined) {
            product.sizes = await this.resolveSizes(sizeIds);
        }
        if (colorIds !== undefined) {
            product.colors = await this.resolveColors(colorIds);
        }
        this.productRepository.merge(product, productData);
        return this.productRepository.save(product);
    }
    async remove(id) {
        const result = await this.productRepository.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Product with ID ${id} not found`);
        }
    }
    async resolveCategory(categoryId) {
        if (categoryId === undefined || categoryId === null) {
            return null;
        }
        const category = await this.categoryRepository.findOne({
            where: { id: categoryId },
        });
        if (!category) {
            throw new common_1.NotFoundException(`Category with ID ${categoryId} not found`);
        }
        return category;
    }
    async resolveSizes(sizeIds) {
        const uniqueIds = Array.from(new Set(sizeIds));
        if (uniqueIds.length === 0) {
            throw new common_1.BadRequestException("At least one size must be provided");
        }
        const sizes = await this.sizeRepository.find({
            where: { id: (0, typeorm_2.In)(uniqueIds) },
        });
        if (sizes.length !== uniqueIds.length) {
            const foundIds = new Set(sizes.map((size) => size.id));
            const missing = uniqueIds.filter((id) => !foundIds.has(id));
            throw new common_1.NotFoundException(`Sizes not found for identifiers: ${missing.join(", ")}`);
        }
        return sizes;
    }
    async resolveColors(colorIds) {
        const uniqueIds = Array.from(new Set(colorIds));
        if (uniqueIds.length === 0) {
            return [];
        }
        const colors = await this.colorRepository.find({
            where: { id: (0, typeorm_2.In)(uniqueIds) },
        });
        if (colors.length !== uniqueIds.length) {
            const foundIds = new Set(colors.map((color) => color.id));
            const missing = uniqueIds.filter((id) => !foundIds.has(id));
            throw new common_1.NotFoundException(`Colors not found for identifiers: ${missing.join(", ")}`);
        }
        return colors;
    }
};
exports.ProductService = ProductService;
exports.ProductService = ProductService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __param(1, (0, typeorm_1.InjectRepository)(category_entity_1.Category)),
    __param(2, (0, typeorm_1.InjectRepository)(size_entity_1.Size)),
    __param(3, (0, typeorm_1.InjectRepository)(color_entity_1.Color)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], ProductService);
//# sourceMappingURL=product.service.js.map