import { CreatePurchaseOrderDto } from './dto/create-purchase-order.dto';
import { UpdatePurchaseOrderDto } from './dto/update-purchase-order.dto';
import { PurchaseOrder } from '../entities/purchase-order.entity';
import { DataSource, Repository } from "typeorm";
import { PurchaseOrderItem } from '../entities/purchase-order-item.entity';
import { Supplier } from '../entities/supplier.entity';
import { StockService } from "../stock/stock.service";
export declare class PurchaseOrderService {
    private readonly purchaseOrderRepository;
    private readonly purchaseOrderItemRepository;
    private readonly supplierRepository;
    private readonly dataSource;
    private readonly stockService;
    constructor(purchaseOrderRepository: Repository<PurchaseOrder>, purchaseOrderItemRepository: Repository<PurchaseOrderItem>, supplierRepository: Repository<Supplier>, dataSource: DataSource, stockService: StockService);
    createPurchaseOrder(createPurchaseOrderDto: CreatePurchaseOrderDto): Promise<PurchaseOrder>;
    updatePurchaseOrder(id: number, updatePurchaseOrderDto: UpdatePurchaseOrderDto): Promise<PurchaseOrder>;
    findAllPurchaseOrders(): Promise<PurchaseOrder[]>;
    getPurchaseOrderById(id: number): Promise<PurchaseOrder>;
    findPurchaseOrdersBySupplier(supplier_id: number): Promise<PurchaseOrder[]>;
    deletePurchaseOrder(id: number): Promise<void>;
    private buildStockSnapshot;
    private applyStockDiff;
}
