"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SizeController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const pagination_dto_1 = require("../common/dto/pagination.dto");
const create_size_dto_1 = require("./dto/create-size.dto");
const update_size_dto_1 = require("./dto/update-size.dto");
const size_service_1 = require("./size.service");
let SizeController = class SizeController {
    sizeService;
    constructor(sizeService) {
        this.sizeService = sizeService;
    }
    create(createSizeDto) {
        return this.sizeService.create(createSizeDto);
    }
    findAll(paginationDto) {
        return this.sizeService.findAll(paginationDto);
    }
    findOne(id) {
        return this.sizeService.findOne(+id);
    }
    update(id, updateSizeDto) {
        return this.sizeService.update(+id, updateSizeDto);
    }
    async remove(id) {
        await this.sizeService.remove(+id);
    }
};
exports.SizeController = SizeController;
__decorate([
    (0, common_1.Post)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.CREATED),
    (0, swagger_1.ApiOperation)({ summary: "Create a new size" }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: "The size has been successfully created.",
    }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Validation failed." }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_size_dto_1.CreateSizeDto]),
    __metadata("design:returntype", void 0)
], SizeController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({
        summary: "Retrieve sizes with pagination and optional search",
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Returns sizes with pagination metadata.",
    }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Validation failed." }),
    (0, swagger_1.ApiQuery)({
        name: "limit",
        type: Number,
        required: false,
        description: "Limit of items per page",
    }),
    (0, swagger_1.ApiQuery)({
        name: "page",
        type: Number,
        required: false,
        description: "Page of items",
    }),
    (0, swagger_1.ApiQuery)({
        name: "query",
        type: String,
        required: false,
        description: "Search keyword (alias: search)",
    }),
    (0, swagger_1.ApiQuery)({
        name: "search",
        type: String,
        required: false,
        description: "Deprecated search keyword; prefer query",
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_dto_1.PaginationDto]),
    __metadata("design:returntype", void 0)
], SizeController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Retrieve a size by ID" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Size identifier" }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Returns the size with the specified ID.",
    }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Size not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SizeController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Update an existing size" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Size identifier" }),
    (0, swagger_1.ApiBody)({ type: update_size_dto_1.UpdateSizeDto }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "The size has been successfully updated.",
    }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Size not found." }),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_size_dto_1.UpdateSizeDto]),
    __metadata("design:returntype", void 0)
], SizeController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(":id"),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, swagger_1.ApiOperation)({ summary: "Delete a size" }),
    (0, swagger_1.ApiParam)({ name: "id", description: "Size identifier" }),
    (0, swagger_1.ApiResponse)({ status: 204, description: "Size removed." }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Size not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], SizeController.prototype, "remove", null);
exports.SizeController = SizeController = __decorate([
    (0, swagger_1.ApiTags)("Sizes"),
    (0, common_1.Controller)("sizes"),
    __metadata("design:paramtypes", [size_service_1.SizeService])
], SizeController);
//# sourceMappingURL=size.controller.js.map