import { Repository } from "typeorm";
import { PaginationDto } from "../common/dto/pagination.dto";
import { Size } from "../entities/size.entity";
import { CreateSizeDto } from "./dto/create-size.dto";
import { UpdateSizeDto } from "./dto/update-size.dto";
export declare class SizeService {
    private readonly sizeRepository;
    constructor(sizeRepository: Repository<Size>);
    create(createSizeDto: CreateSizeDto): Promise<Size>;
    findAll(paginationDto: PaginationDto): Promise<{
        data: Size[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    findOne(id: number): Promise<Size>;
    update(id: number, updateSizeDto: UpdateSizeDto): Promise<Size>;
    remove(id: number): Promise<void>;
    private handlePersistenceError;
}
