"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SizeService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const size_entity_1 = require("../entities/size.entity");
let SizeService = class SizeService {
    sizeRepository;
    constructor(sizeRepository) {
        this.sizeRepository = sizeRepository;
    }
    async create(createSizeDto) {
        const size = this.sizeRepository.create(createSizeDto);
        try {
            return await this.sizeRepository.save(size);
        }
        catch (error) {
            this.handlePersistenceError(error);
        }
    }
    async findAll(paginationDto) {
        const page = Math.max(Number.parseInt(paginationDto.page ?? "1", 10) || 1, 1);
        const limit = Math.max(Number.parseInt(paginationDto.limit ?? "10", 10) || 10, 1);
        const search = paginationDto.searchTerm;
        const queryBuilder = this.sizeRepository
            .createQueryBuilder("size")
            .orderBy("size.name", "ASC");
        if (search) {
            queryBuilder.where("LOWER(size.name) LIKE LOWER(:search)", {
                search: `%${search}%`,
            });
        }
        const [data, total] = await queryBuilder
            .skip((page - 1) * limit)
            .take(limit)
            .getManyAndCount();
        const totalPages = total > 0 ? Math.ceil(total / limit) : 0;
        return {
            data,
            page,
            limit,
            total,
            previous: page > 1 ? page - 1 : null,
            next: page < totalPages ? page + 1 : null,
        };
    }
    async findOne(id) {
        const size = await this.sizeRepository.findOne({ where: { id } });
        if (!size) {
            throw new common_1.NotFoundException(`Size with ID ${id} not found`);
        }
        return size;
    }
    async update(id, updateSizeDto) {
        const size = await this.findOne(id);
        this.sizeRepository.merge(size, updateSizeDto);
        try {
            return await this.sizeRepository.save(size);
        }
        catch (error) {
            this.handlePersistenceError(error);
        }
    }
    async remove(id) {
        const size = await this.findOne(id);
        await this.sizeRepository.remove(size);
    }
    handlePersistenceError(error) {
        if (error instanceof typeorm_2.QueryFailedError) {
            const driverError = error.code;
            if (driverError === "23505" || driverError === "ER_DUP_ENTRY") {
                throw new common_1.BadRequestException("Size name must be unique");
            }
        }
        throw error;
    }
};
exports.SizeService = SizeService;
exports.SizeService = SizeService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(size_entity_1.Size)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], SizeService);
//# sourceMappingURL=size.service.js.map