import { StockService } from "./stock.service";
import { CreateStockDto } from "./dto/create-stock.dto";
import { StockReportQueryDto } from "./dto/stock-report-query.dto";
export declare class StockController {
    private readonly stockService;
    constructor(stockService: StockService);
    findAll(): Promise<import("../entities/stock.entity").Stock[]>;
    addStock(createStockDto: CreateStockDto): Promise<import("../entities/stock.entity").Stock>;
    getReport(month?: string): Promise<Record<string, unknown>>;
    getSupplierProductReport(query: StockReportQueryDto): Promise<{
        meta: {
            generatedAt: string;
            startDate: string;
            endDate: string;
            startInclusive: string;
            endExclusive: string;
        };
        data: {
            stockId: number | null;
            productId: number;
            date: string;
            productName: string;
            todayNewStock: number;
            bookedOrder: number;
            completedStock: number;
            productCode: string | null;
            return: number;
            openingStock: number;
            closing: number;
            sizeWithColor: {
                size_id: number | null;
                size_name: string | null;
                color: string | null;
                stock: number;
            }[];
        }[];
    }>;
    getStatusReport(): Promise<{
        meta: {
            generatedAt: string;
            totals: {
                preorder: number;
                completed: number;
                order: number;
                stock: number;
            };
        };
        data: {
            productId: number | null;
            productName: string | null;
            productCode: string | null;
            sizeId: number | null;
            size: string | null;
            colorId: number | null;
            color: string | null;
            preorderQuantity: number;
            completedQuantity: number;
            currentStock: number;
            orderQuantity: number;
        }[];
    }>;
}
