"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const stock_service_1 = require("./stock.service");
const create_stock_dto_1 = require("./dto/create-stock.dto");
const stock_report_query_dto_1 = require("./dto/stock-report-query.dto");
let StockController = class StockController {
    stockService;
    constructor(stockService) {
        this.stockService = stockService;
    }
    findAll() {
        return this.stockService.listStocks();
    }
    addStock(createStockDto) {
        return this.stockService.addNewStock(createStockDto);
    }
    getReport(month) {
        return this.stockService.generateMonthlyReport(month);
    }
    getSupplierProductReport(query) {
        return this.stockService.generateSupplierProductReport(query);
    }
    getStatusReport() {
        return this.stockService.generateStatusReport();
    }
};
exports.StockController = StockController;
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: "List all stock levels" }),
    (0, swagger_1.ApiResponse)({ status: 200, description: "Current stock quantities" }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], StockController.prototype, "findAll", null);
__decorate([
    (0, common_1.Post)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.CREATED),
    (0, swagger_1.ApiOperation)({ summary: "Add new stock quantity for a product" }),
    (0, swagger_1.ApiBody)({ type: create_stock_dto_1.CreateStockDto }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: "Stock quantity has been updated.",
    }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_stock_dto_1.CreateStockDto]),
    __metadata("design:returntype", void 0)
], StockController.prototype, "addStock", null);
__decorate([
    (0, common_1.Get)("report"),
    (0, swagger_1.ApiOperation)({ summary: "Generate a monthly stock report" }),
    (0, swagger_1.ApiQuery)({
        name: "month",
        required: false,
        description: "Target month in YYYY-MM format",
        example: "2025-07",
    }),
    (0, swagger_1.ApiResponse)({ status: 200, description: "AntD-compatible stock report" }),
    __param(0, (0, common_1.Query)("month")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], StockController.prototype, "getReport", null);
__decorate([
    (0, common_1.Get)("report/supplier-product"),
    (0, swagger_1.ApiOperation)({
        summary: "Generate product-wise supplier stock report",
        description: "Aggregates stock movements by product for the provided date range and returns size/color level breakdown for new stock.",
    }),
    (0, swagger_1.ApiQuery)({
        name: "startDate",
        required: true,
        description: "Start date (inclusive) in YYYY-MM-DD format",
    }),
    (0, swagger_1.ApiQuery)({
        name: "endDate",
        required: true,
        description: "End date (inclusive) in YYYY-MM-DD format",
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Product-wise supplier stock report",
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [stock_report_query_dto_1.StockReportQueryDto]),
    __metadata("design:returntype", void 0)
], StockController.prototype, "getSupplierProductReport", null);
__decorate([
    (0, common_1.Get)("report/variants/daily"),
    (0, swagger_1.ApiOperation)({
        summary: "Generate day-wise variant report for a date range",
        description: "Returns one row per day within the provided range, listing purchases with size/color details and cost rollups.",
    }),
    (0, swagger_1.ApiQuery)({
        name: "startDate",
        required: true,
        description: "Start date (inclusive) in YYYY-MM-DD format",
    }),
    (0, swagger_1.ApiQuery)({
        name: "endDate",
        required: true,
        description: "End date (inclusive) in YYYY-MM-DD format",
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Day-wise stock intake breakdown",
    }),
    (0, common_1.Get)("report/status"),
    (0, swagger_1.ApiOperation)({
        summary: "Generate supplier status stock report",
        description: "Summarises stock quantities by product, size, color and supplier status (preorder/completed).",
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Supplier status stock breakdown",
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], StockController.prototype, "getStatusReport", null);
exports.StockController = StockController = __decorate([
    (0, swagger_1.ApiTags)("Stock"),
    (0, common_1.Controller)("stocks"),
    __metadata("design:paramtypes", [stock_service_1.StockService])
], StockController);
//# sourceMappingURL=stock.controller.js.map