import { DataSource, EntityManager, Repository } from "typeorm";
import { StockMovement, StockMovementType } from "../entities/stock-movement.entity";
import { Stock } from "../entities/stock.entity";
import { SupplierProduct } from "../entities/supplier-product.entity";
import { CreateStockDto } from "./dto/create-stock.dto";
import { StockReportQueryDto } from "./dto/stock-report-query.dto";
interface AdjustStockInput {
    productId: number;
    sizeId: number;
    quantity: number;
    movementType: StockMovementType;
    manager?: EntityManager;
    referenceType?: string;
    referenceId?: number;
    createIfMissing?: boolean;
    colorId?: number | null;
}
export declare class StockService {
    private readonly stockRepository;
    private readonly stockMovementRepository;
    private readonly supplierProductRepository;
    private readonly dataSource;
    constructor(stockRepository: Repository<Stock>, stockMovementRepository: Repository<StockMovement>, supplierProductRepository: Repository<SupplierProduct>, dataSource: DataSource);
    listStocks(): Promise<Stock[]>;
    addNewStock(createStockDto: CreateStockDto): Promise<Stock>;
    increaseStock(input: AdjustStockInput): Promise<Stock>;
    decreaseStock(input: AdjustStockInput): Promise<Stock>;
    private adjustStock;
    generateSupplierProductReport(query: StockReportQueryDto): Promise<{
        meta: {
            generatedAt: string;
            startDate: string;
            endDate: string;
            startInclusive: string;
            endExclusive: string;
        };
        data: {
            stockId: number | null;
            productId: number;
            date: string;
            productName: string;
            todayNewStock: number;
            bookedOrder: number;
            completedStock: number;
            productCode: string | null;
            return: number;
            openingStock: number;
            closing: number;
            sizeWithColor: Array<{
                size_id: number | null;
                size_name: string | null;
                color: string | null;
                stock: number;
            }>;
        }[];
    }>;
    generateStatusReport(): Promise<{
        meta: {
            generatedAt: string;
            totals: {
                preorder: number;
                completed: number;
                order: number;
                stock: number;
            };
        };
        data: {
            productId: number | null;
            productName: string | null;
            productCode: string | null;
            sizeId: number | null;
            size: string | null;
            colorId: number | null;
            color: string | null;
            preorderQuantity: number;
            completedQuantity: number;
            currentStock: number;
            orderQuantity: number;
        }[];
    }>;
    private buildVariantKey;
    private resolveDateRange;
    private normalizeDateOnly;
    generateMonthlyReport(month?: string): Promise<Record<string, unknown>>;
    private resolveReportRange;
    private parseYmdDate;
    private resolveMonth;
    private buildReportColumns;
}
export {};
