"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateBulkSupplierProductDto = void 0;
const class_validator_1 = require("class-validator");
const class_transformer_1 = require("class-transformer");
const create_supplier_product_dto_1 = require("./create-supplier-product.dto");
const swagger_1 = require("@nestjs/swagger");
class CreateBulkSupplierProductDto {
    supplier_id;
    products;
    quantity;
    unit_price;
}
exports.CreateBulkSupplierProductDto = CreateBulkSupplierProductDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: "The ID of the supplier", example: 1 }),
    (0, class_validator_1.IsInt)(),
    __metadata("design:type", Number)
], CreateBulkSupplierProductDto.prototype, "supplier_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "An array of products to assign to the supplier",
        type: [create_supplier_product_dto_1.CreateSupplierProductDto],
    }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => create_supplier_product_dto_1.CreateSupplierProductDto),
    __metadata("design:type", Array)
], CreateBulkSupplierProductDto.prototype, "products", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: "The quantity of the products", example: 10 }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], CreateBulkSupplierProductDto.prototype, "quantity", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "The unit price of the products",
        example: 99.99,
    }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsPositive)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], CreateBulkSupplierProductDto.prototype, "unit_price", void 0);
//# sourceMappingURL=create-bulk-supplier-product.dto.js.map