"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateSupplierProductDto = exports.SupplierProductSizeDto = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
class SupplierProductSizeDto {
    size_id;
    quantity;
    color_id;
}
exports.SupplierProductSizeDto = SupplierProductSizeDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "Identifier of the size for this supplier product entry",
        example: 5,
    }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], SupplierProductSizeDto.prototype, "size_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "Quantity for the specific size",
        example: 10,
    }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], SupplierProductSizeDto.prototype, "quantity", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: "Identifier of the color variant for this size entry. Falls back to the top-level color if omitted.",
        example: 3,
    }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SupplierProductSizeDto.prototype, "color_id", void 0);
class CreateSupplierProductDto {
    supplier_id;
    product_id;
    unit_price;
    quantity;
    sizes;
    status;
    note;
    purchase_date;
}
exports.CreateSupplierProductDto = CreateSupplierProductDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: "The ID of the supplier", example: 1 }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], CreateSupplierProductDto.prototype, "supplier_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: "The ID of the product", example: 1 }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], CreateSupplierProductDto.prototype, "product_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "The price of the product from this supplier",
        example: 99.99,
    }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], CreateSupplierProductDto.prototype, "unit_price", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "The quantity of the product from this supplier",
        example: 30,
    }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsPositive)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], CreateSupplierProductDto.prototype, "quantity", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "Breakdown of sizes with their quantities, optionally specifying color per size.",
        type: [SupplierProductSizeDto],
        example: [
            { size_id: 1, quantity: 10, color_id: 3 },
            { size_id: 2, quantity: 20, color_id: 4 },
        ],
    }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ArrayNotEmpty)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => SupplierProductSizeDto),
    __metadata("design:type", Array)
], CreateSupplierProductDto.prototype, "sizes", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: "Current fulfillment status for the supplier product record.",
        enum: ["preorder", "completed"],
        example: "completed",
    }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(["preorder", "completed"]),
    __metadata("design:type", String)
], CreateSupplierProductDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "Additional notes about the supplier product",
        example: "Preferred supplier for bulk orders",
        required: false,
    }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateSupplierProductDto.prototype, "note", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: "The date the product was purchased from the supplier",
        example: "2024-03-01",
        required: false,
        type: String,
        format: "date",
    }),
    (0, class_validator_1.IsDateString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateSupplierProductDto.prototype, "purchase_date", void 0);
//# sourceMappingURL=create-supplier-product.dto.js.map