import { SupplierProductService } from "./supplier-product.service";
import { CreateSupplierProductDto } from "./dto/create-supplier-product.dto";
import { CreateBulkSupplierProductDto } from "./dto/create-bulk-supplier-product.dto";
import { SupplierProduct } from "../entities/supplier-product.entity";
import { SupplierProductListQueryDto } from "./dto/list-supplier-product-query.dto";
export declare class SupplierProductController {
    private readonly supplierProductService;
    constructor(supplierProductService: SupplierProductService);
    listSupplierProducts(query: SupplierProductListQueryDto): Promise<{
        data: SupplierProduct[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    getProductVariantOptions(productId: number): Promise<{
        productId: number;
        productName: string;
        sizes: Array<{
            id: number;
            name: string;
        }>;
        colors: Array<{
            id: number;
            name: string;
        }>;
    }>;
    assignProductToSupplier(createSupplierProductDto: CreateSupplierProductDto): Promise<SupplierProduct>;
    findProductsBySupplier(supplierId: string): Promise<SupplierProduct[]>;
    removeAssignment(supplierId: string, productId: string): Promise<void>;
    createBulk(createBulkSupplierProductDto: CreateBulkSupplierProductDto): Promise<SupplierProduct[]>;
}
