"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierProductController = void 0;
const common_1 = require("@nestjs/common");
const supplier_product_service_1 = require("./supplier-product.service");
const create_supplier_product_dto_1 = require("./dto/create-supplier-product.dto");
const create_bulk_supplier_product_dto_1 = require("./dto/create-bulk-supplier-product.dto");
const supplier_product_entity_1 = require("../entities/supplier-product.entity");
const swagger_1 = require("@nestjs/swagger");
const list_supplier_product_query_dto_1 = require("./dto/list-supplier-product-query.dto");
let SupplierProductController = class SupplierProductController {
    supplierProductService;
    constructor(supplierProductService) {
        this.supplierProductService = supplierProductService;
    }
    listSupplierProducts(query) {
        return this.supplierProductService.searchSupplierProducts(query);
    }
    getProductVariantOptions(productId) {
        return this.supplierProductService.getProductVariantOptions(productId);
    }
    assignProductToSupplier(createSupplierProductDto) {
        return this.supplierProductService.assignProductToSupplier(createSupplierProductDto);
    }
    findProductsBySupplier(supplierId) {
        return this.supplierProductService.findProductsBySupplier(+supplierId);
    }
    removeAssignment(supplierId, productId) {
        return this.supplierProductService.removeAssignment(+supplierId, +productId);
    }
    createBulk(createBulkSupplierProductDto) {
        return this.supplierProductService.createBulk(createBulkSupplierProductDto);
    }
};
exports.SupplierProductController = SupplierProductController;
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({
        summary: "List supplier products with optional search filters",
    }),
    (0, swagger_1.ApiQuery)({
        name: "search",
        required: false,
        description: "Search term matched against product name, code, color, or supplier name",
    }),
    (0, swagger_1.ApiQuery)({
        name: "supplierId",
        required: false,
        description: "Filter by supplier identifier",
    }),
    (0, swagger_1.ApiOkResponse)({
        description: "Paginated supplier product list",
        schema: {
            type: "object",
            properties: {
                data: {
                    type: "array",
                    items: { $ref: (0, swagger_1.getSchemaPath)(supplier_product_entity_1.SupplierProduct) },
                },
                page: { type: "number" },
                limit: { type: "number" },
                total: { type: "number" },
                previous: { type: "number", nullable: true },
                next: { type: "number", nullable: true },
            },
        },
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [list_supplier_product_query_dto_1.SupplierProductListQueryDto]),
    __metadata("design:returntype", void 0)
], SupplierProductController.prototype, "listSupplierProducts", null);
__decorate([
    (0, common_1.Get)("/product/:productId/options"),
    (0, swagger_1.ApiOperation)({
        summary: "Get size and color options available for a specific product",
    }),
    (0, swagger_1.ApiParam)({
        name: "productId",
        description: "Identifier of the product",
    }),
    (0, swagger_1.ApiOkResponse)({
        description: "Size and color options associated with the product",
        schema: {
            type: "object",
            properties: {
                productId: { type: "number" },
                productName: { type: "string" },
                sizes: {
                    type: "array",
                    items: {
                        type: "object",
                        properties: {
                            id: { type: "number" },
                            name: { type: "string" },
                        },
                    },
                },
                colors: {
                    type: "array",
                    items: {
                        type: "object",
                        properties: {
                            id: { type: "number" },
                            name: { type: "string" },
                        },
                    },
                },
            },
        },
    }),
    (0, swagger_1.ApiNotFoundResponse)({ description: "Product not found." }),
    __param(0, (0, common_1.Param)("productId", common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], SupplierProductController.prototype, "getProductVariantOptions", null);
__decorate([
    (0, common_1.Post)("/assign"),
    (0, common_1.HttpCode)(common_1.HttpStatus.CREATED),
    (0, swagger_1.ApiOperation)({ summary: "Assign a product to a supplier" }),
    (0, swagger_1.ApiBody)({
        type: create_supplier_product_dto_1.CreateSupplierProductDto,
        description: "Data to assign a product to a supplier",
        examples: {
            singleColor: {
                summary: "Single color with per-size quantities",
                value: {
                    supplier_id: 1,
                    product_id: 1,
                    unit_price: 99.99,
                    quantity: 30,
                    sizes: [
                        { size_id: 1, quantity: 10, color_id: 3 },
                        { size_id: 2, quantity: 20, color_id: 4 },
                    ],
                    note: "Preferred supplier for bulk orders",
                    purchase_date: "2024-03-01",
                },
            },
            multiColor: {
                summary: "Multiple colors with color-wise sizes",
                value: {
                    supplier_id: 1,
                    product_id: 2,
                    unit_price: 150.0,
                    quantity: 25,
                    sizes: [
                        { size_id: 3, quantity: 12, color_id: 2 },
                        { size_id: 4, quantity: 13, color_id: 5 },
                    ],
                    purchase_date: "2024-05-20",
                },
            },
        },
    }),
    (0, swagger_1.ApiCreatedResponse)({ type: supplier_product_entity_1.SupplierProduct, description: "New supplier inventory record created." }),
    (0, swagger_1.ApiOkResponse)({
        type: supplier_product_entity_1.SupplierProduct,
        description: "Existing supplier inventory restocked; response includes history.",
    }),
    (0, swagger_1.ApiNotFoundResponse)({ description: "Supplier or Product not found." }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Bad Request." }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_supplier_product_dto_1.CreateSupplierProductDto]),
    __metadata("design:returntype", void 0)
], SupplierProductController.prototype, "assignProductToSupplier", null);
__decorate([
    (0, common_1.Get)("/supplier/:supplierId"),
    (0, swagger_1.ApiOperation)({ summary: "Get all products assigned to a specific supplier" }),
    (0, swagger_1.ApiParam)({ name: "supplierId", description: "ID of the supplier" }),
    (0, swagger_1.ApiOkResponse)({ type: [supplier_product_entity_1.SupplierProduct], description: "Successfully retrieved products for the supplier." }),
    (0, swagger_1.ApiNotFoundResponse)({ description: "Supplier not found." }),
    __param(0, (0, common_1.Param)("supplierId")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SupplierProductController.prototype, "findProductsBySupplier", null);
__decorate([
    (0, common_1.Delete)("/supplier/:supplierId/product/:productId"),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, swagger_1.ApiOperation)({ summary: "Remove a product assignment from a supplier" }),
    (0, swagger_1.ApiParam)({ name: "supplierId", description: "ID of the supplier" }),
    (0, swagger_1.ApiParam)({ name: "productId", description: "ID of the product" }),
    (0, swagger_1.ApiNoContentResponse)({ description: "Product assignment successfully removed." }),
    (0, swagger_1.ApiNotFoundResponse)({ description: "Assignment not found." }),
    __param(0, (0, common_1.Param)("supplierId")),
    __param(1, (0, common_1.Param)("productId")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], SupplierProductController.prototype, "removeAssignment", null);
__decorate([
    (0, common_1.Post)("bulk"),
    (0, swagger_1.ApiOperation)({
        summary: "Create multiple supplier products for a single supplier",
    }),
    (0, swagger_1.ApiCreatedResponse)({
        description: "Successfully recorded inventory for the supplier.",
        type: [supplier_product_entity_1.SupplierProduct],
    }),
    (0, swagger_1.ApiBody)({
        type: create_bulk_supplier_product_dto_1.CreateBulkSupplierProductDto,
        description: "Data to create multiple supplier products for a single supplier",
    }),
    (0, swagger_1.ApiNotFoundResponse)({ description: "Supplier not found." }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Bad Request." }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_bulk_supplier_product_dto_1.CreateBulkSupplierProductDto]),
    __metadata("design:returntype", void 0)
], SupplierProductController.prototype, "createBulk", null);
exports.SupplierProductController = SupplierProductController = __decorate([
    (0, swagger_1.ApiTags)("Supplier-Products"),
    (0, common_1.Controller)("api/supplier-products"),
    __metadata("design:paramtypes", [supplier_product_service_1.SupplierProductService])
], SupplierProductController);
//# sourceMappingURL=supplier-product.controller.js.map