import { Repository } from "typeorm";
import { SupplierProduct } from "../entities/supplier-product.entity";
import { CreateSupplierProductDto } from "./dto/create-supplier-product.dto";
import { CreateBulkSupplierProductDto } from "./dto/create-bulk-supplier-product.dto";
import { Supplier } from "../entities/supplier.entity";
import { Product } from "../entities/product.entity";
import { StockService } from "../stock/stock.service";
import { Size } from "../entities/size.entity";
import { Color } from "../entities/color.entity";
import { SupplierProductListQueryDto } from "./dto/list-supplier-product-query.dto";
export declare class SupplierProductService {
    private readonly supplierProductRepository;
    private readonly supplierRepository;
    private readonly productRepository;
    private readonly sizeRepository;
    private readonly colorRepository;
    private readonly stockService;
    constructor(supplierProductRepository: Repository<SupplierProduct>, supplierRepository: Repository<Supplier>, productRepository: Repository<Product>, sizeRepository: Repository<Size>, colorRepository: Repository<Color>, stockService: StockService);
    assignProductToSupplier(createSupplierProductDto: CreateSupplierProductDto): Promise<SupplierProduct>;
    private createOrRestockSupplierProduct;
    private resolveSizes;
    searchSupplierProducts(query: SupplierProductListQueryDto): Promise<{
        data: SupplierProduct[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    getProductVariantOptions(productId: number): Promise<{
        productId: number;
        productName: string;
        sizes: Array<{
            id: number;
            name: string;
        }>;
        colors: Array<{
            id: number;
            name: string;
        }>;
    }>;
    findProductsBySupplier(supplierId: number): Promise<SupplierProduct[]>;
    removeAssignment(supplierId: number, productId: number): Promise<void>;
    createBulk(createBulkSupplierProductDto: CreateBulkSupplierProductDto): Promise<SupplierProduct[]>;
    private extractSizeRequests;
    private buildVariantKey;
    private derivePrimaryColor;
}
