import { PaginationDto } from "../common/dto/pagination.dto";
import { CreateSupplierDto } from "./dto/create-supplier.dto";
import { UpdateSupplierDto } from "./dto/update-supplier.dto";
import { SupplierService } from "./supplier.service";
export declare class SupplierController {
    private readonly supplierService;
    constructor(supplierService: SupplierService);
    create(createSupplierDto: CreateSupplierDto): Promise<import("../entities/supplier.entity").Supplier>;
    findAll(paginationDto: PaginationDto): Promise<{
        data: import("../entities/supplier.entity").Supplier[];
        page: number;
        limit: number;
        total: number;
        previous: number | null;
        next: number | null;
    }>;
    findOne(id: string): Promise<import("../entities/supplier.entity").Supplier>;
    update(id: string, updateSupplierDto: UpdateSupplierDto): Promise<import("../entities/supplier.entity").Supplier>;
    remove(id: string): Promise<{
        success: boolean;
        message: string;
    }>;
}
