"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const pagination_dto_1 = require("../common/dto/pagination.dto");
const create_supplier_dto_1 = require("./dto/create-supplier.dto");
const update_supplier_dto_1 = require("./dto/update-supplier.dto");
const supplier_service_1 = require("./supplier.service");
let SupplierController = class SupplierController {
    supplierService;
    constructor(supplierService) {
        this.supplierService = supplierService;
    }
    create(createSupplierDto) {
        return this.supplierService.create(createSupplierDto);
    }
    findAll(paginationDto) {
        return this.supplierService.findAll(paginationDto);
    }
    findOne(id) {
        return this.supplierService.findOne(+id);
    }
    update(id, updateSupplierDto) {
        return this.supplierService.update(+id, updateSupplierDto);
    }
    async remove(id) {
        await this.supplierService.remove(+id);
        return { success: true, message: "Supplier deleted successfully" };
    }
};
exports.SupplierController = SupplierController;
__decorate([
    (0, common_1.Post)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.CREATED),
    (0, swagger_1.ApiOperation)({ summary: "Create a new supplier" }),
    (0, swagger_1.ApiResponse)({
        status: 201,
        description: "The supplier has been successfully created.",
    }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Bad Request." }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_supplier_dto_1.CreateSupplierDto]),
    __metadata("design:returntype", void 0)
], SupplierController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({
        summary: "Retrieve all suppliers with pagination and search",
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Returns all suppliers with pagination and search.",
    }),
    (0, swagger_1.ApiQuery)({
        name: "limit",
        type: Number,
        required: false,
        description: "Limit of items per page",
    }),
    (0, swagger_1.ApiQuery)({
        name: "page",
        type: Number,
        required: false,
        description: "Page of items",
    }),
    (0, swagger_1.ApiQuery)({
        name: "query",
        type: String,
        required: false,
        description: "Search keyword (alias: search)",
    }),
    (0, swagger_1.ApiQuery)({
        name: "search",
        type: String,
        required: false,
        description: "Deprecated search keyword; prefer query",
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_dto_1.PaginationDto]),
    __metadata("design:returntype", void 0)
], SupplierController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Retrieve a supplier by ID" }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "Returns the supplier with the specified ID.",
    }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Supplier not found." }),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SupplierController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(":id"),
    (0, swagger_1.ApiOperation)({ summary: "Update a supplier by ID" }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: "The supplier has been successfully updated.",
    }),
    (0, swagger_1.ApiResponse)({ status: 404, description: "Supplier not found." }),
    (0, swagger_1.ApiResponse)({ status: 400, description: "Bad Request." }),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_supplier_dto_1.UpdateSupplierDto]),
    __metadata("design:returntype", void 0)
], SupplierController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], SupplierController.prototype, "remove", null);
exports.SupplierController = SupplierController = __decorate([
    (0, swagger_1.ApiTags)("Suppliers"),
    (0, common_1.Controller)("api/suppliers"),
    __metadata("design:paramtypes", [supplier_service_1.SupplierService])
], SupplierController);
//# sourceMappingURL=supplier.controller.js.map