"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const supplier_entity_1 = require("../entities/supplier.entity");
let SupplierService = class SupplierService {
    supplierRepository;
    constructor(supplierRepository) {
        this.supplierRepository = supplierRepository;
    }
    async create(createSupplierDto) {
        const { email, phone } = createSupplierDto;
        const existingSupplier = await this.supplierRepository.findOne({
            where: [{ email }, { phone }],
        });
        if (existingSupplier) {
            if (existingSupplier.email === email) {
                throw new common_1.ConflictException(`Supplier with email "${email}" already exists.`);
            }
            if (existingSupplier.phone === phone) {
                throw new common_1.ConflictException(`Supplier with phone "${phone}" already exists.`);
            }
        }
        const supplier = new supplier_entity_1.Supplier();
        Object.assign(supplier, createSupplierDto);
        return this.supplierRepository.save(supplier);
    }
    async findAll(paginationDto) {
        const page = Math.max(Number.parseInt(paginationDto.page ?? "1", 10) || 1, 1);
        const limit = Math.max(Number.parseInt(paginationDto.limit ?? "10", 10) || 10, 1);
        const search = paginationDto.searchTerm;
        const queryBuilder = this.supplierRepository
            .createQueryBuilder("supplier")
            .orderBy("supplier.created_at", "DESC");
        if (search) {
            queryBuilder.where("(LOWER(supplier.name) LIKE LOWER(:search) OR LOWER(supplier.email) LIKE LOWER(:search) OR LOWER(supplier.phone) LIKE LOWER(:search))", { search: `%${search}%` });
        }
        const [data, total] = await queryBuilder
            .skip((page - 1) * limit)
            .take(limit)
            .getManyAndCount();
        const totalPages = total > 0 ? Math.ceil(total / limit) : 0;
        return {
            data,
            page,
            limit,
            total,
            previous: page > 1 ? page - 1 : null,
            next: page < totalPages ? page + 1 : null,
        };
    }
    async findOne(id) {
        const supplier = await this.supplierRepository.findOneBy({ id });
        if (!supplier) {
            throw new common_1.NotFoundException(`Supplier with id: ${id} not found`);
        }
        return supplier;
    }
    async update(id, updateSupplierDto) {
        const supplier = await this.findOne(id);
        this.supplierRepository.merge(supplier, updateSupplierDto);
        return this.supplierRepository.save(supplier);
    }
    async remove(id) {
        const result = await this.supplierRepository.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Supplier with ID ${id} not found`);
        }
    }
};
exports.SupplierService = SupplierService;
exports.SupplierService = SupplierService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(supplier_entity_1.Supplier)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], SupplierService);
//# sourceMappingURL=supplier.service.js.map