import { Repository } from "typeorm";
import { User } from "../entities/user.entity";
type CreateUserInput = Pick<User, "name" | "email" | "password" | "phone" | "status">;
export declare class UsersService {
    private readonly usersRepository;
    constructor(usersRepository: Repository<User>);
    create(data: CreateUserInput): Promise<User>;
    findByEmail(email: string): Promise<User | null>;
    findById(id: number): Promise<User | null>;
}
export {};
