#!/usr/bin/env node
const { spawnSync } = require("child_process");
const fs = require("fs");
const path = require("path");

const args = process.argv.slice(2);
const optionArgs = args.filter((arg) => arg.startsWith("-"));
const nameArgs = args.filter((arg) => !arg.startsWith("-"));

if (nameArgs.length === 0) {
  console.error("Please provide a migration name, e.g. npm run migration:generate -- createUsers");
  process.exit(1);
}

const migrationName = nameArgs[nameArgs.length - 1];
const targetPath = path.join("src", "migrations", migrationName);

fs.mkdirSync(path.join("src", "migrations"), { recursive: true });

const result = spawnSync(
  "npx",
  [
    "typeorm-ts-node-commonjs",
    "migration:generate",
    targetPath,
    "-d",
    "typeorm.config.ts",
    ...optionArgs,
  ],
  {
    stdio: "inherit",
    shell: process.platform === "win32",
  },
);

if (result.status !== 0) {
  process.exit(result.status ?? 1);
}
