import { Module } from "@nestjs/common";
import { ConfigModule } from "@nestjs/config";
import { APP_GUARD } from "@nestjs/core";
import { AppController } from "./app.controller";
import { AppService } from "./app.service";
import { DatabaseModule } from "./database/database.module";

import { AuthModule } from "./auth/auth.module";
import { CategoryModule } from "./category/category.module";
import { PrivateRouteGuard } from "./common/guards/private-route.guard";
import { CustomerModule } from "./customer/customer.module";
import { DashboardModule } from "./dashboard/dashboard.module";
import { OrderModule } from "./order/order.module";
import { ProductModule } from "./product/product.module";
import { PurchaseOrderModule } from "./purchase-order/purchase-order.module";
import { StockModule } from "./stock/stock.module";
import { SupplierProductModule } from "./supplier-product/supplier-product.module";
import { SupplierModule } from "./supplier/supplier.module";
import { SizeModule } from "./size/size.module";
import { ColorModule } from "./color/color.module";

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true, // Makes the ConfigService available throughout the application
    }),
    DatabaseModule,
    SupplierModule,
    ProductModule,
    SupplierProductModule,
    PurchaseOrderModule,
    AuthModule,
    CustomerModule,
    DashboardModule,
    StockModule,
    OrderModule,
    CategoryModule,
    SizeModule,
    ColorModule,
  ],
  controllers: [AppController],
  providers: [
    AppService,
    {
      provide: APP_GUARD,
      useClass: PrivateRouteGuard,
    },
  ],
})
export class AppModule {}
