import { Body, Controller, Get, Post, Req } from "@nestjs/common";
import { ApiBearerAuth, ApiTags } from "@nestjs/swagger";
import { Request } from "express";
import { Private } from "../common/decorators/private.decorator";
import { AuthService, type AuthResponse } from "./auth.service";

type AuthenticatedRequest = Request & { user: AuthResponse["user"] };
import { LoginDto } from "./dto/login.dto";
import { RegisterUserDto } from "./dto/register-user.dto";

@ApiTags("Auth")
@Controller("auth")
export class AuthController {
  constructor(private readonly authService: AuthService) {}

  @Post("register")
  register(@Body() dto: RegisterUserDto): Promise<AuthResponse> {
    return this.authService.register(dto);
  }

  @Post("login")
  login(@Body() dto: LoginDto): Promise<AuthResponse> {
    return this.authService.login(dto);
  }

  @Get("me")
  @Private()
  @ApiBearerAuth("JWT")
  profile(@Req() request: AuthenticatedRequest): AuthResponse["user"] {
    return request.user;
  }
}
