import { ApiProperty } from "@nestjs/swagger";
import { IsEmail, IsNotEmpty, IsString } from "class-validator";

export class LoginDto {
  @ApiProperty({
    description: "Registered email address",
    example: "jane.doe@example.com",
  })
  @IsEmail()
  email: string;

  @ApiProperty({
    description: "Corresponding account password",
    example: "changeme123",
  })
  @IsString()
  @IsNotEmpty()
  password: string;
}
