import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import {
  IsEmail,
  IsIn,
  IsNotEmpty,
  IsOptional,
  IsString,
  MinLength,
} from "class-validator";

export class RegisterUserDto {
  @ApiProperty({
    description: "Full name of the user",
    example: "Jane Doe",
  })
  @IsString()
  @IsNotEmpty()
  name: string;

  @ApiProperty({
    description: "Unique email address used for authentication",
    example: "jane.doe@example.com",
  })
  @IsEmail()
  email: string;

  @ApiProperty({
    description: "Password used for authentication (minimum 6 characters)",
    example: "changeme123",
    minLength: 6,
  })
  @IsString()
  @MinLength(6)
  password: string;

  @ApiPropertyOptional({
    description: "Contact phone number for the user",
    example: "+8801712345678",
  })
  @IsOptional()
  @IsString()
  phone?: string;

  @ApiPropertyOptional({
    description:
      "User status flag where 1 means active and 0 represents inactive",
    example: 1,
    enum: [0, 1],
  })
  @IsOptional()
  @IsIn([0, 1])
  status?: number;
}
