import {
  IsInt,
  IsIn,
  IsNotEmpty,
  IsOptional,
  IsString,
  MaxLength,
  Min,
} from "class-validator";
import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";

export class CreateCategoryDto {
  @ApiProperty({
    description: "Unique name for the category",
    example: "Wallets",
  })
  @IsString()
  @IsNotEmpty()
  @MaxLength(255)
  category_name: string;

  @ApiPropertyOptional({
    description: "Display title for the category",
    example: "Premium Wallet Collection",
  })
  @IsString()
  @IsOptional()
  @MaxLength(255)
  title?: string;

  @ApiPropertyOptional({
    description: "Subtitle for the category",
    example: "Crafted from genuine leather",
  })
  @IsString()
  @IsOptional()
  @MaxLength(255)
  subtitle?: string;

  @ApiPropertyOptional({
    description: "Identifier of the parent category",
    example: 1,
  })
  @IsInt()
  @Min(1)
  @IsOptional()
  parentId?: number | null;

  @ApiPropertyOptional({
    description: "Category status where 1=active and 0=inactive",
    example: 1,
    default: 1,
  })
  @IsIn([0, 1])
  @IsOptional()
  status?: number;
}
