import { IsOptional, IsNumberString, IsString } from "class-validator";

export class PaginationDto {
  @IsOptional()
  @IsNumberString()
  page?: string;

  @IsOptional()
  @IsNumberString()
  limit?: string;

  @IsOptional()
  @IsString()
  search?: string;

  @IsOptional()
  @IsString()
  query?: string;

  get searchTerm(): string {
    return (this.query ?? this.search ?? "").trim();
  }
}
