import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import {
  IsEmail,
  IsNotEmpty,
  IsOptional,
  IsString,
  MaxLength,
} from "class-validator";

export class CreateCustomerDto {
  @ApiProperty({ description: "Customer first name", example: "Amina" })
  @IsString()
  @IsNotEmpty()
  @MaxLength(80)
  firstName: string;

  @ApiProperty({ description: "Customer last name", example: "Rahman" })
  @IsString()
  @IsNotEmpty()
  @MaxLength(80)
  lastName: string;

  @ApiProperty({
    description: "Primary email address",
    example: "amina.rahman@example.com",
  })
  @IsEmail()
  @MaxLength(120)
  email: string;

  @ApiPropertyOptional({
    description: "Optional phone number in E.164 format",
    example: "+8801700000000",
  })
  @IsOptional()
  @IsString()
  @MaxLength(20)
  phone?: string;

  @ApiPropertyOptional({
    description: "Mailing address for the customer",
    example: "House 10, Road 11, Dhanmondi, Dhaka",
  })
  @IsOptional()
  @IsString()
  address?: string;
}
