import { Controller, Get, Query } from "@nestjs/common";
import { ApiOkResponse, ApiOperation, ApiQuery, ApiTags } from "@nestjs/swagger";
import { DashboardService } from "./dashboard.service";
import { DashboardOverviewDto } from "./dto/dashboard-overview.dto";
import { DashboardOverviewQueryDto } from "./dto/dashboard-overview-query.dto";

@ApiTags("Dashboard")
@Controller("dashboard")
export class DashboardController {
  constructor(private readonly dashboardService: DashboardService) {}

  @Get("overview")
  @ApiOperation({ summary: "Retrieve aggregated dashboard metrics" })
  @ApiQuery({
    name: "startDate",
    required: false,
    description:
      "Only include records created on or after this ISO datetime value",
    type: String,
  })
  @ApiQuery({
    name: "endDate",
    required: false,
    description:
      "Only include records created on or before this ISO datetime value",
    type: String,
  })
  @ApiOkResponse({
    description:
      "Counts for supplier products, orders, customers, and order returns",
    type: DashboardOverviewDto,
  })
  getOverview(
    @Query() filters: DashboardOverviewQueryDto,
  ): Promise<DashboardOverviewDto> {
    return this.dashboardService.getOverview(filters);
  }
}
