import { Module } from "@nestjs/common";
import { TypeOrmModule } from "@nestjs/typeorm";
import { DashboardController } from "./dashboard.controller";
import { DashboardService } from "./dashboard.service";
import { SupplierProduct } from "../entities/supplier-product.entity";
import { Order } from "../entities/order.entity";
import { Customer } from "../entities/customer.entity";
import { OrderReturn } from "../entities/order-return.entity";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      SupplierProduct,
      Order,
      Customer,
      OrderReturn,
    ]),
  ],
  controllers: [DashboardController],
  providers: [DashboardService],
  exports: [DashboardService],
})
export class DashboardModule {}
