import { ApiPropertyOptional } from "@nestjs/swagger";
import { IsDateString, IsOptional } from "class-validator";

export class DashboardOverviewQueryDto {
  @ApiPropertyOptional({
    description:
      "Filter counts to records created on or after this ISO date value",
    example: "2024-01-01T00:00:00.000Z",
  })
  @IsOptional()
  @IsDateString()
  startDate?: string;

  @ApiPropertyOptional({
    description:
      "Filter counts to records created on or before this ISO date value",
    example: "2024-01-31T23:59:59.999Z",
  })
  @IsOptional()
  @IsDateString()
  endDate?: string;
}
