import { ApiProperty } from "@nestjs/swagger";

export class DashboardOverviewDto {
  @ApiProperty({
    description: "Total number of supplier products tracked in the system",
    example: 125,
  })
  totalSupplierProducts: number;

  @ApiProperty({
    description: "Total number of customer orders placed",
    example: 320,
  })
  totalOrders: number;

  @ApiProperty({
    description: "Total number of registered customers",
    example: 58,
  })
  totalCustomers: number;

  @ApiProperty({
    description: "Total number of processed order returns",
    example: 14,
  })
  totalReturns: number;
}
